/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.remoting3;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class UnlockedReadIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private final Object writeLock = new Object();
    private final Set<Map.Entry<K, V>> entrySet = new EntrySet();
    private final float loadFactor;
    private volatile int size;
    private volatile AtomicReferenceArray<Item<K, V>[]> table;
    private int threshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnlockedReadIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be > 0");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be > 0.0f");
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        Object object = this.writeLock;
        synchronized (object) {
            this.threshold = (int)((float)capacity * loadFactor);
            this.table = new AtomicReferenceArray(capacity);
        }
    }

    UnlockedReadIdentityHashMap(float loadFactor) {
        this(512, loadFactor);
    }

    UnlockedReadIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.6f);
    }

    UnlockedReadIdentityHashMap() {
        this(512, 0.6f);
    }

    private void resize() {
        assert (Thread.holdsLock(this.writeLock));
        AtomicReferenceArray<Item<K, V>[]> oldTable = this.table;
        int oldCapacity = oldTable.length();
        if (oldCapacity == 0x40000000) {
            return;
        }
        int newCapacity = oldCapacity << 1;
        AtomicReferenceArray<Item[]> newTable = new AtomicReferenceArray<Item[]>(newCapacity);
        int newThreshold = (int)((float)newCapacity * this.loadFactor);
        for (int i = 0; i < oldCapacity; ++i) {
            Item<K, V>[] items = oldTable.get(i);
            if (items == null) continue;
            for (Item<K, V> item : items) {
                int hc = System.identityHashCode(item) & newCapacity - 1;
                Item[] old = (Item[])newTable.get(hc);
                if (old == null) {
                    newTable.lazySet(hc, new Item[]{item});
                    continue;
                }
                int oldLen = old.length;
                Item[] copy = Arrays.copyOf(old, oldLen + 1);
                copy[oldLen] = item;
                newTable.lazySet(hc, copy);
            }
        }
        this.table = newTable;
        this.threshold = newThreshold;
    }

    private static <K, V> Item<K, V> doGet(AtomicReferenceArray<Item<K, V>[]> table, Object key) {
        Item<K, V>[] row = UnlockedReadIdentityHashMap.doGetRow(table, key);
        return row == null ? null : UnlockedReadIdentityHashMap.doGet(row, key);
    }

    private static <K, V> Item<K, V>[] doGetRow(AtomicReferenceArray<Item<K, V>[]> table, Object key) {
        int hc = UnlockedReadIdentityHashMap.getIndex(table, key);
        return UnlockedReadIdentityHashMap.doGetRow(table, hc);
    }

    private static <K, V> int getIndex(AtomicReferenceArray<Item<K, V>[]> table, Object key) {
        return System.identityHashCode(key) & table.length() - 1;
    }

    private static <K, V> Item<K, V>[] doGetRow(AtomicReferenceArray<Item<K, V>[]> table, int hc) {
        return table.get(hc);
    }

    private static <K, V> Item<K, V> doGet(Item<K, V>[] row, Object key) {
        for (Item<K, V> item : row) {
            if (key != ((Item)item).key) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doPut(AtomicReferenceArray<Item<K, V>[]> table, K key, V value, boolean ifAbsent) {
        int hc = UnlockedReadIdentityHashMap.getIndex(table, key);
        Item<K, V>[] old = UnlockedReadIdentityHashMap.doGetRow(table, hc);
        if (old == null) {
            Item[] newRow = new Item[]{new Item(key, value)};
            table.set(hc, newRow);
            if (this.size++ == this.threshold) {
                this.resize();
            }
            return null;
        }
        Item<K, V> item = UnlockedReadIdentityHashMap.doGet(old, key);
        if (item != null) {
            try {
                Object object = ((Item)item).value;
                return (V)object;
            }
            finally {
                if (!ifAbsent) {
                    ((Item)item).value = value;
                }
            }
        }
        int oldLen = old.length;
        Item<K, V>[] newRow = Arrays.copyOf(old, oldLen + 1);
        newRow[oldLen] = new Item(key, value);
        table.set(hc, newRow);
        if (this.size++ == this.threshold) {
            this.resize();
        }
        return null;
    }

    private static <K, V> Item<K, V>[] remove(Item<K, V>[] row, int idx) {
        int len = row.length;
        assert (idx < len);
        if (len == 1) {
            return null;
        }
        Item[] newRow = new Item[len - 1];
        if (idx > 0) {
            System.arraycopy(row, 0, newRow, 0, idx);
        }
        if (idx < len - 1) {
            System.arraycopy(row, idx + 1, newRow, idx, len - 1 - idx);
        }
        return newRow;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        Item<K, V> item = UnlockedReadIdentityHashMap.doGet(this.table, key);
        return item != null;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        Item<K, V> item = UnlockedReadIdentityHashMap.doGet(this.table, key);
        return (V)(item == null ? null : ((Item)item).value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Object object = this.writeLock;
        synchronized (object) {
            return this.doPut(this.table, key, value, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        Object object = this.writeLock;
        synchronized (object) {
            int hc = UnlockedReadIdentityHashMap.getIndex(this.table, key);
            Item<K, V>[] row = UnlockedReadIdentityHashMap.doGetRow(this.table, hc);
            if (row == null) {
                return null;
            }
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                Item<K, V> item = row[i];
                if (key != ((Item)item).key) continue;
                this.table.set(hc, UnlockedReadIdentityHashMap.remove(row, i));
                --this.size;
                return (V)((Item)item).value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.writeLock;
        synchronized (object) {
            this.table = new AtomicReferenceArray(this.table.length());
            this.size = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Object object = this.writeLock;
        synchronized (object) {
            return this.doPut(this.table, key, value, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            return false;
        }
        Object object = this.writeLock;
        synchronized (object) {
            int hc = UnlockedReadIdentityHashMap.getIndex(this.table, key);
            Item<K, V>[] row = UnlockedReadIdentityHashMap.doGetRow(this.table, hc);
            if (row == null) {
                return false;
            }
            int rowLen = row.length;
            for (int i = 0; i < rowLen; ++i) {
                Item<K, V> item = row[i];
                if (key != ((Item)item).key || !(value == null ? ((Item)item).value == null : value.equals(((Item)item).value))) continue;
                this.table.set(hc, UnlockedReadIdentityHashMap.remove(row, i));
                --this.size;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null) {
            return false;
        }
        Object object = this.writeLock;
        synchronized (object) {
            Item<K, V> item = UnlockedReadIdentityHashMap.doGet(this.table, key);
            if (item != null && (oldValue == null ? ((Item)item).value == null : oldValue.equals(((Item)item).value))) {
                ((Item)item).value = newValue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V replace(K key, V value) {
        if (key == null) {
            return null;
        }
        Object object = this.writeLock;
        synchronized (object) {
            Item<K, V> item = UnlockedReadIdentityHashMap.doGet(this.table, key);
            if (item == null) {
                return null;
            }
            Object object2 = ((Item)item).value;
            return (V)object2;
            finally {
                ((Item)item).value = value;
            }
        }
    }

    private static final class Item<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private volatile V value;

        private Item(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            try {
                V v = this.value;
                return v;
            }
            finally {
                this.value = value;
            }
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Item && this.equals((Item)obj);
        }

        public boolean equals(Item<?, ?> obj) {
            return obj != null && obj.key == this.key;
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final AtomicReferenceArray<Item<K, V>[]> table;
        private int tableIdx;
        private int itemIdx;
        private Item<K, V> next;

        private EntryIterator() {
            this.table = UnlockedReadIdentityHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                int len;
                if (this.table.length() == this.tableIdx) {
                    return false;
                }
                Item<K, V>[] items = this.table.get(this.tableIdx);
                if (items != null && this.itemIdx < (len = items.length)) {
                    this.next = items[this.itemIdx++];
                    return true;
                }
                this.itemIdx = 0;
                ++this.tableIdx;
            }
            return true;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                try {
                    Item item = this.next;
                    return item;
                }
                finally {
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return UnlockedReadIdentityHashMap.this.size();
        }
    }
}

