/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.remoting3.security;

import infinispan.org.jboss.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

public class PasswordClientCallbackHandler
implements CallbackHandler {
    private static final Logger log = Logger.getLogger("org.jboss.remoting.security.client");
    private final String actualUserName;
    private final String actualUserRealm;
    private final char[] password;
    public static final char[] EMPTY_PASSWORD = new char[0];

    public PasswordClientCallbackHandler(String actualUserName, String actualUserRealm, char[] password) {
        this.actualUserName = actualUserName;
        this.actualUserRealm = actualUserRealm;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        block5: for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                String defaultName = nameCallback.getDefaultName();
                log.tracef("User name requested; prompt '%s', default is '%s', ours is '%s'", (Object)nameCallback.getPrompt(), (Object)defaultName, (Object)this.actualUserName);
                if (this.actualUserName == null) {
                    if (defaultName == null) continue;
                    nameCallback.setName(defaultName);
                    continue;
                }
                nameCallback.setName(this.actualUserName);
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback realmCallback = (RealmCallback)callback;
                String defaultRealm = realmCallback.getDefaultText();
                log.tracef("Realm requested; prompt '%s', default is '%s', ours is '%s'", (Object)realmCallback.getPrompt(), (Object)defaultRealm, (Object)this.actualUserRealm);
                if (this.actualUserRealm == null) {
                    if (defaultRealm == null) continue;
                    realmCallback.setText(defaultRealm);
                    continue;
                }
                realmCallback.setText(this.actualUserRealm);
                continue;
            }
            if (callback instanceof RealmChoiceCallback && this.actualUserRealm != null) {
                RealmChoiceCallback realmChoiceCallback = (RealmChoiceCallback)callback;
                String[] choices = realmChoiceCallback.getChoices();
                for (int i = 0; i < choices.length; ++i) {
                    if (choices[i] == null || !choices[i].equals(this.actualUserRealm)) continue;
                    realmChoiceCallback.setSelectedIndex(i);
                    continue block5;
                }
                throw new UnsupportedCallbackException(callback, "No realm choices match realm '" + this.actualUserRealm + "'");
            }
            if (callback instanceof TextOutputCallback) {
                String kind;
                TextOutputCallback textOutputCallback = (TextOutputCallback)callback;
                switch (textOutputCallback.getMessageType()) {
                    case 2: {
                        kind = "ERROR";
                        break;
                    }
                    case 0: {
                        kind = "INFORMATION";
                        break;
                    }
                    case 1: {
                        kind = "WARNING";
                        break;
                    }
                    default: {
                        kind = "UNKNOWN";
                    }
                }
                log.debugf("Authentication layer produced a %s message: %s", (Object)kind, (Object)textOutputCallback.getMessage());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

