/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.filter.Filters;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.remote.client.ContinuousQueryResult;

public final class ContinuousQueryImpl<K, V>
implements ContinuousQuery<K, V> {
    private final RemoteCache<K, V> cache;
    private final SerializationContext serializationContext;
    private final List<ClientEntryListener> listeners = new ArrayList<ClientEntryListener>();

    public ContinuousQueryImpl(RemoteCache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter cannot be null");
        }
        this.cache = cache;
        this.serializationContext = ProtoStreamMarshaller.getSerializationContext(cache.getRemoteCacheManager());
    }

    @Override
    public <C> void addContinuousQueryListener(Query query, ContinuousQueryListener<K, C> listener) {
        ClientEntryListener eventListener = new ClientEntryListener(this.serializationContext, listener);
        Object[] factoryParams = Filters.makeFactoryParams(query);
        this.cache.addClientListener(eventListener, factoryParams, null);
        this.listeners.add(eventListener);
    }

    @Override
    public void removeContinuousQueryListener(ContinuousQueryListener<K, ?> listener) {
        Iterator<ClientEntryListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            ClientEntryListener l = it.next();
            if (l.listener != listener) continue;
            this.cache.removeClientListener(l);
            it.remove();
            break;
        }
    }

    @Override
    public List<ContinuousQueryListener<K, ?>> getListeners() {
        ArrayList queryListeners = new ArrayList(this.listeners.size());
        for (ClientEntryListener l : this.listeners) {
            queryListeners.add(l.listener);
        }
        return queryListeners;
    }

    @Override
    public void removeAllListeners() {
        for (ClientEntryListener l : this.listeners) {
            this.cache.removeClientListener(l);
        }
        this.listeners.clear();
    }

    @ClientListener(filterFactoryName="continuous-query-filter-converter-factory", converterFactoryName="continuous-query-filter-converter-factory", useRawData=true, includeCurrentState=true)
    private static final class ClientEntryListener<K, V> {
        private final SerializationContext serializationContext;
        private final ContinuousQueryListener listener;

        public ClientEntryListener(SerializationContext serializationContext, ContinuousQueryListener listener) {
            this.serializationContext = serializationContext;
            this.listener = listener;
        }

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        @ClientCacheEntryRemoved
        @ClientCacheEntryExpired
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent<byte[]> event) throws IOException {
            Object[] value;
            ContinuousQueryResult cqr = ProtobufUtil.fromByteArray(this.serializationContext, event.getEventData(), ContinuousQueryResult.class);
            Object key = ProtobufUtil.fromWrappedByteArray(this.serializationContext, cqr.getKey());
            Object object = value = cqr.getValue() != null ? ProtobufUtil.fromWrappedByteArray(this.serializationContext, cqr.getValue()) : cqr.getProjection();
            if (cqr.isJoining()) {
                this.listener.resultJoining(key, value);
            } else {
                this.listener.resultLeaving(key);
            }
        }
    }
}

