/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import infinispan.org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class TransportObjectFactory
extends BaseKeyedPoolableObjectFactory<SocketAddress, TcpTransport> {
    private static final Log log = LogFactory.getLog(TransportObjectFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final TcpTransportFactory tcpTransportFactory;
    protected final AtomicInteger defaultCacheTopologyId;
    protected final boolean pingOnStartup;
    protected volatile boolean firstPingExecuted = false;
    protected final Codec codec;

    public TransportObjectFactory(Codec codec, TcpTransportFactory tcpTransportFactory, AtomicInteger defaultCacheTopologyId, boolean pingOnStartup) {
        this.tcpTransportFactory = tcpTransportFactory;
        this.defaultCacheTopologyId = defaultCacheTopologyId;
        this.pingOnStartup = pingOnStartup;
        this.codec = codec;
    }

    @Override
    public TcpTransport makeObject(SocketAddress address) throws Exception {
        TcpTransport tcpTransport = new TcpTransport(address, this.tcpTransportFactory);
        if (trace) {
            log.tracef("Created tcp transport: %s", (Object)tcpTransport);
        }
        if (this.pingOnStartup && !this.firstPingExecuted) {
            if (trace) {
                log.trace("Executing first ping!");
            }
            this.firstPingExecuted = true;
            this.ping(tcpTransport, this.defaultCacheTopologyId);
        }
        return tcpTransport;
    }

    protected PingOperation.PingResult ping(TcpTransport tcpTransport, AtomicInteger topologyId) {
        PingOperation po = new PingOperation(this.codec, topologyId, tcpTransport);
        return po.execute();
    }

    @Override
    public boolean validateObject(SocketAddress address, TcpTransport transport) {
        try {
            boolean valid = this.ping(transport, this.defaultCacheTopologyId).isSuccess();
            if (trace) {
                log.tracef("Is connection %s valid? %s", (Object)transport, (Object)valid);
            }
            return valid;
        }
        catch (Throwable e) {
            if (trace) {
                log.tracef(e, "Error validating the connection %s. Marking it as invalid.", (Object)transport);
            }
            return false;
        }
    }

    @Override
    public void destroyObject(SocketAddress address, TcpTransport transport) throws Exception {
        if (trace) {
            log.tracef("About to destroy tcp transport: %s", (Object)transport);
        }
        transport.destroy();
    }

    @Override
    public void activateObject(SocketAddress address, TcpTransport transport) throws Exception {
        super.activateObject(address, transport);
        if (trace) {
            log.tracef("Fetching from pool: %s", (Object)transport);
        }
    }

    @Override
    public void passivateObject(SocketAddress address, TcpTransport transport) throws Exception {
        super.passivateObject(address, transport);
        if (trace) {
            log.tracef("Returning to pool: %s", (Object)transport);
        }
    }
}

