/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access.constraint;

import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.JmxAction;
import infinispan.org.jboss.as.controller.access.JmxTarget;
import infinispan.org.jboss.as.controller.access.TargetAttribute;
import infinispan.org.jboss.as.controller.access.TargetResource;
import infinispan.org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import infinispan.org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import infinispan.org.jboss.as.controller.access.constraint.AuditConstraint;
import infinispan.org.jboss.as.controller.access.constraint.AuditLogAddressUtil;
import infinispan.org.jboss.as.controller.access.constraint.Constraint;
import infinispan.org.jboss.as.controller.access.constraint.ConstraintFactory;
import infinispan.org.jboss.as.controller.access.constraint.ScopingConstraintFactory;
import infinispan.org.jboss.as.controller.access.rbac.StandardRole;

public class NonAuditConstraint
extends AllowAllowNotConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    private static final NonAuditConstraint AUDIT = new NonAuditConstraint(true);
    private static final NonAuditConstraint NOT_AUDIT = new NonAuditConstraint(false);
    private static final NonAuditConstraint ALLOWS = new NonAuditConstraint(true, true);
    private static final NonAuditConstraint DISALLOWS = new NonAuditConstraint(true, false);

    private NonAuditConstraint(boolean isAudit) {
        super(isAudit);
    }

    private NonAuditConstraint(boolean allowsAudit, boolean allowsNonAudit) {
        super(allowsAudit, allowsNonAudit);
    }

    private static class Factory
    extends AbstractConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return role == StandardRole.AUDITOR && (actionEffect == Action.ActionEffect.WRITE_CONFIG || actionEffect == Action.ActionEffect.WRITE_RUNTIME) ? DISALLOWS : ALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(actionEffect, action, target.getTargetResource());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isAuditResource(target) ? AUDIT : NOT_AUDIT;
        }

        private boolean isAuditResource(TargetResource target) {
            return AuditLogAddressUtil.isAuditLogAddress(target.getResourceAddress());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return other instanceof ScopingConstraintFactory || other instanceof AuditConstraint.Factory ? 1 : -1;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return NOT_AUDIT;
        }
    }
}

