/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access.rbac;

import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.AuthorizerConfiguration;
import infinispan.org.jboss.as.controller.access.Caller;
import infinispan.org.jboss.as.controller.access.Environment;
import infinispan.org.jboss.as.controller.access.JmxAction;
import infinispan.org.jboss.as.controller.access.JmxTarget;
import infinispan.org.jboss.as.controller.access.TargetAttribute;
import infinispan.org.jboss.as.controller.access.TargetResource;
import infinispan.org.jboss.as.controller.access.rbac.RoleMapper;
import infinispan.org.jboss.as.controller.access.rbac.StandardRole;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import java.util.Collections;
import java.util.Set;

public class SuperUserRoleMapper
implements RoleMapper {
    private final Set<String> SUPERUSER = Collections.singleton(StandardRole.SUPERUSER.toString());
    private final AuthorizerConfiguration authorizerConfiguration;

    public SuperUserRoleMapper(AuthorizerConfiguration configuration) {
        this.authorizerConfiguration = configuration;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetAttribute attribute) {
        return this.SUPERUSER;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetResource resource) {
        return this.SUPERUSER;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, JmxAction action, JmxTarget target) {
        return this.SUPERUSER;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Set<String> operationHeaderRoles) {
        return this.SUPERUSER;
    }

    @Override
    public boolean canRunAs(Set<String> mappedRoles, String runAsRole) {
        if (runAsRole == null) {
            return false;
        }
        boolean hasRole = this.authorizerConfiguration.hasRole(runAsRole);
        boolean isSuperUser = mappedRoles.contains(StandardRole.SUPERUSER.toString());
        if (isSuperUser && !hasRole) {
            throw ControllerLogger.ROOT_LOGGER.unknownRole(runAsRole);
        }
        return hasRole && isSuperUser;
    }
}

