/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client.impl;

import infinispan.org.jboss.as.controller.client.ModelControllerClient;
import infinispan.org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import infinispan.org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import infinispan.org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import infinispan.org.jboss.remoting3.Channel;
import infinispan.org.jboss.remoting3.CloseHandler;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExistingChannelModelControllerClient
extends AbstractModelControllerClient {
    private final ManagementChannelHandler handler;

    protected ExistingChannelModelControllerClient(ManagementChannelHandler handler) {
        this.handler = handler;
    }

    @Override
    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.handler;
    }

    @Override
    public void close() throws IOException {
        this.handler.shutdown();
    }

    public static ModelControllerClient createAndAdd(ManagementChannelHandler handler) {
        ExistingChannelModelControllerClient client = new ExistingChannelModelControllerClient(handler);
        handler.addHandlerFactory(client);
        return client;
    }

    public static ModelControllerClient createReceiving(Channel channel, ExecutorService executorService) {
        final ManagementChannelHandler handler = new ManagementChannelHandler(channel, executorService);
        ExistingChannelModelControllerClient client = new ExistingChannelModelControllerClient(handler);
        handler.addHandlerFactory(client);
        channel.addCloseHandler(new CloseHandler<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleClose(Channel closed, IOException exception) {
                handler.shutdown();
                try {
                    handler.awaitCompletion(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    handler.shutdownNow();
                }
            }
        });
        channel.receiveMessage(handler.getReceiver());
        return client;
    }
}

