/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.registry.AliasEntry;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.as.controller.transform.OperationRejectionPolicy;
import infinispan.org.jboss.as.controller.transform.OperationResultTransformer;
import infinispan.org.jboss.as.controller.transform.OperationTransformer;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.as.controller.transform.TransformationTarget;
import infinispan.org.jboss.as.controller.transform.TransformersImpl;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.ArrayList;
import java.util.List;

class CompositeOperationTransformer
implements OperationTransformer {
    private static final ModelNode SUCCESSFUL = new ModelNode();

    CompositeOperationTransformer() {
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        return this.transformOperation(context, address, operation, false);
    }

    OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation, boolean nested) throws OperationFailedException {
        assert (address.size() == 0);
        ModelNode composite = operation.clone();
        composite.get("steps").setEmptyList();
        TransformationTarget target = context.getTarget();
        ArrayList<Step> steps = new ArrayList<Step>();
        int stepIdx = 0;
        int resultIdx = 0;
        for (ModelNode step : operation.require("steps").asList()) {
            OperationTransformer.TransformedOperation result;
            PathAddress stepAddress;
            ++stepIdx;
            String operationName = step.require("operation").asString();
            PathAddress pathAddress = stepAddress = step.hasDefined("address") ? PathAddress.pathAddress(step.require("address")) : PathAddress.EMPTY_ADDRESS;
            if (stepAddress.size() == 0 && "composite".equals(operationName)) {
                result = this.transformOperation(context, PathAddress.EMPTY_ADDRESS, step, false);
            } else {
                ImmutableManagementResourceRegistration reg = context.getResourceRegistration(stepAddress);
                PathAddress useAddress = reg != null && reg.isAlias() ? reg.getAliasEntry().convertToTargetAddress(stepAddress, AliasEntry.AliasContext.create(step, context)) : stepAddress;
                OperationTransformer transformer = target.resolveTransformer(context, useAddress, operationName);
                PathAddress transformed = TransformersImpl.transformAddress(useAddress, target);
                step.get("address").set(transformed.toModelNode());
                result = transformer.transformOperation(context, transformed, step);
            }
            ModelNode transformedOperation = result.getTransformedOperation();
            if (transformedOperation != null) {
                composite.get("steps").add(transformedOperation);
                ++resultIdx;
            }
            steps.add(new Step(stepIdx, resultIdx, result));
        }
        CompositeResultTransformer resultHandler = new CompositeResultTransformer(steps);
        return new OperationTransformer.TransformedOperation(composite, resultHandler, resultHandler);
    }

    static {
        SUCCESSFUL.get("outcome").set("success");
        SUCCESSFUL.get("result");
        SUCCESSFUL.protect();
    }

    private static class Step {
        private final int stepCount;
        private final int resultingIdx;
        private final OperationTransformer.TransformedOperation result;

        private Step(int step, int resultingIdx, OperationTransformer.TransformedOperation result) {
            this.stepCount = step;
            this.resultingIdx = resultingIdx;
            this.result = result;
        }

        boolean isDiscarded() {
            return this.result.getTransformedOperation() == null;
        }

        int getResultingIdx() {
            return this.resultingIdx;
        }

        int getStepCount() {
            return this.stepCount;
        }

        OperationTransformer.TransformedOperation getResult() {
            return this.result;
        }

        public String toString() {
            return "Step{step=" + this.stepCount + ", operation=" + this.result.getTransformedOperation() + '}';
        }
    }

    private static class CompositeResultTransformer
    implements OperationResultTransformer,
    OperationRejectionPolicy {
        private final List<Step> steps;
        private volatile Step failedStep;

        private CompositeResultTransformer(List<Step> steps) {
            this.steps = steps;
        }

        @Override
        public boolean rejectOperation(ModelNode preparedResult) {
            for (Step step : this.steps) {
                OperationTransformer.TransformedOperation stepPolicy;
                ModelNode stepResult;
                if (step.isDiscarded()) continue;
                String resultIdx = "step-" + step.getResultingIdx();
                ModelNode modelNode = stepResult = preparedResult.hasDefined("result", resultIdx) ? preparedResult.get("result", resultIdx) : new ModelNode();
                if (stepResult.hasDefined("outcome") && "ignored-by-unaffected-host-controller".equals(stepResult.get("outcome").asString()) || !(stepPolicy = step.getResult()).rejectOperation(stepResult)) continue;
                this.failedStep = step;
                return true;
            }
            return false;
        }

        @Override
        public String getFailureDescription() {
            if (this.failedStep != null) {
                return this.failedStep.getResult().getFailureDescription();
            }
            return "";
        }

        @Override
        public ModelNode transformResult(ModelNode original) {
            ModelNode response = original.clone();
            ModelNode result = response.get("result").setEmptyObject();
            boolean modified = false;
            for (Step step : this.steps) {
                ModelNode transformed;
                ModelNode stepResult;
                String stepIdx = "step-" + step.getStepCount();
                if (step.isDiscarded()) {
                    result.get(stepIdx).set(SUCCESSFUL);
                    continue;
                }
                String resultIdx = "step-" + step.getResultingIdx();
                ModelNode modelNode = stepResult = original.hasDefined("result", resultIdx) ? original.get("result", resultIdx) : new ModelNode();
                if (stepResult.hasDefined("outcome") && "ignored-by-unaffected-host-controller".equals(stepResult.get("outcome").asString())) {
                    result.get(stepIdx).set(SUCCESSFUL);
                    modified = true;
                    continue;
                }
                OperationTransformer.TransformedOperation transformer = step.getResult();
                if (step.getResult().rejectOperation(stepResult)) {
                    stepResult.get("outcome").set("failed");
                    stepResult.get("failure-description").set(step.getResult().getFailureDescription());
                }
                if (!(transformed = transformer.transformResult(stepResult)).isDefined() && !original.has("result", resultIdx)) continue;
                result.get(stepIdx).set(transformer.transformResult(stepResult));
                modified = true;
            }
            return modified ? response : original;
        }
    }
}

