/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.transform.OperationRejectionPolicy;
import infinispan.org.jboss.as.controller.transform.OperationResultTransformer;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.dmr.ModelNode;

public interface OperationTransformer {
    public static final OperationTransformer DEFAULT = new OperationTransformer(){

        @Override
        public TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode original) throws OperationFailedException {
            return new TransformedOperation(original, OperationResultTransformer.ORIGINAL_RESULT);
        }
    };
    public static final OperationTransformer DISCARD = new OperationTransformer(){

        @Override
        public TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            return new TransformedOperation(null, DEFAULT_REJECTION_POLICY, SUCCESSFUL_RESULT);
        }
    };
    public static final OperationResultTransformer SUCCESSFUL_RESULT = new OperationResultTransformer(){

        @Override
        public ModelNode transformResult(ModelNode ignored) {
            ModelNode result = new ModelNode();
            result.get("outcome").set("success");
            result.get("result");
            return result;
        }
    };
    public static final OperationRejectionPolicy DEFAULT_REJECTION_POLICY = new OperationRejectionPolicy(){

        @Override
        public boolean rejectOperation(ModelNode preparedResult) {
            return false;
        }

        @Override
        public String getFailureDescription() {
            return null;
        }
    };

    public TransformedOperation transformOperation(TransformationContext var1, PathAddress var2, ModelNode var3) throws OperationFailedException;

    public static class TransformedOperation
    implements OperationResultTransformer,
    OperationRejectionPolicy {
        private final ModelNode transformedOperation;
        private final OperationRejectionPolicy rejectPolicy;
        private final OperationResultTransformer resultTransformer;

        public TransformedOperation(ModelNode transformedOperation, OperationResultTransformer resultTransformer) {
            this(transformedOperation, DEFAULT_REJECTION_POLICY, resultTransformer);
        }

        public TransformedOperation(ModelNode transformedOperation, OperationRejectionPolicy policy, OperationResultTransformer resultTransformer) {
            this.transformedOperation = transformedOperation;
            this.rejectPolicy = policy;
            this.resultTransformer = resultTransformer;
        }

        public ModelNode getTransformedOperation() {
            return this.transformedOperation;
        }

        public OperationResultTransformer getResultTransformer() {
            return this.resultTransformer;
        }

        @Override
        public boolean rejectOperation(ModelNode preparedResult) {
            return this.rejectPolicy.rejectOperation(preparedResult);
        }

        @Override
        public String getFailureDescription() {
            return this.rejectPolicy.getFailureDescription();
        }

        @Override
        public ModelNode transformResult(ModelNode result) {
            return this.resultTransformer.transformResult(result);
        }
    }
}

