/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol.mgmt;

import java.util.HashSet;
import java.util.Set;

public interface ManagementBatchIdManager {
    public boolean lockBatchId(int var1);

    public int createBatchId();

    public void freeBatchId(int var1);

    public static class DefaultManagementBatchIdManager
    implements ManagementBatchIdManager {
        private final Set<Integer> ids = new HashSet<Integer>();

        @Override
        public synchronized boolean lockBatchId(int id) {
            if (this.ids.contains(id)) {
                return false;
            }
            this.ids.add(id);
            return true;
        }

        @Override
        public synchronized int createBatchId() {
            int next = (int)(Math.random() * 2.147483647E9);
            while (this.ids.contains(next)) {
                next = (int)(Math.random() * 2.147483647E9);
            }
            this.ids.add(next);
            return next;
        }

        @Override
        public synchronized void freeBatchId(int id) {
            this.ids.remove(id);
        }
    }
}

