/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.resource;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleResourceDefinition;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintDefinition;
import infinispan.org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import infinispan.org.jboss.as.controller.capability.RuntimeCapability;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.StringLengthValidator;
import infinispan.org.jboss.as.controller.registry.AttributeAccess;
import infinispan.org.jboss.as.controller.registry.ManagementResourceRegistration;
import infinispan.org.jboss.as.controller.registry.OperationEntry;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSocketBindingGroupResourceDefinition
extends SimpleResourceDefinition {
    public static final String SOCKET_BINDING_GROUP_CAPABILITY_NAME = "org.wildfly.domain.socket-binding-group";
    public static final RuntimeCapability SOCKET_BINDING_GROUP_CAPABILITY = RuntimeCapability.Builder.of("org.wildfly.domain.socket-binding-group", true).build();
    public static final PathElement PATH = PathElement.pathElement("socket-binding-group");
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setResourceOnly()).setValidator(new StringLengthValidator(1))).build();
    public static final SimpleAttributeDefinition DEFAULT_INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-interface", ModelType.STRING, false).setAllowExpression(true)).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES)).setCapabilityReference("org.wildfly.network.interface", SOCKET_BINDING_GROUP_CAPABILITY)).build();
    private final List<AccessConstraintDefinition> accessConstraints = SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG.wrapAsList();

    public AbstractSocketBindingGroupResourceDefinition(OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(new SimpleResourceDefinition.Parameters(PATH, ControllerResolver.getResolver("socket-binding-group")).setAddHandler(addHandler).setRemoveHandler(removeHandler).setAddRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES));
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(NAME, null);
        resourceRegistration.registerReadWriteAttribute(DEFAULT_INTERFACE, null, new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEFAULT_INTERFACE}){

            @Override
            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                AbstractSocketBindingGroupResourceDefinition.validateDefaultInterfaceReference(context, model.getModel());
            }
        });
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public static void validateDefaultInterfaceReference(OperationContext context, ModelNode bindingGroup) throws OperationFailedException {
        ModelNode defaultInterfaceNode = bindingGroup.get(DEFAULT_INTERFACE.getName());
        if (defaultInterfaceNode.getType() == ModelType.STRING) {
            PathElement element;
            String defaultInterface = defaultInterfaceNode.asString();
            PathAddress operationAddress = context.getCurrentAddress();
            PathAddress interfaceAddress = PathAddress.EMPTY_ADDRESS;
            Iterator iterator = operationAddress.iterator();
            while (iterator.hasNext() && !(element = (PathElement)iterator.next()).getKey().equals("socket-binding-group")) {
                interfaceAddress = interfaceAddress.append(element);
            }
            interfaceAddress = interfaceAddress.append("interface", defaultInterface);
            try {
                context.readResourceFromRoot(interfaceAddress, false);
            }
            catch (RuntimeException e) {
                throw ControllerLogger.ROOT_LOGGER.nonexistentInterface(defaultInterface, DEFAULT_INTERFACE.getName());
            }
        }
    }

    @Override
    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(SOCKET_BINDING_GROUP_CAPABILITY);
    }
}

