/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform.description;

import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.transform.description.AttributeConverter;
import infinispan.org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import infinispan.org.jboss.as.controller.transform.description.RejectAttributeChecker;
import infinispan.org.jboss.as.controller.transform.description.RejectedAttributesLogContext;
import infinispan.org.jboss.as.controller.transform.description.TransformationRule;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Collections;
import java.util.List;

class AttributeTransformationDescription {
    final String name;
    final List<RejectAttributeChecker> checks;
    final String newName;
    final DiscardAttributeChecker discardChecker;
    final AttributeConverter converter;

    AttributeTransformationDescription(String name, List<RejectAttributeChecker> checks, String newName, DiscardAttributeChecker discardChecker, AttributeConverter converter) {
        this.name = name;
        this.checks = checks != null ? checks : Collections.emptyList();
        this.newName = newName;
        this.discardChecker = discardChecker;
        this.converter = converter;
    }

    boolean shouldDiscard(PathAddress address, ModelNode attributeValue, ModelNode operation, TransformationRule.AbstractChainedContext context) {
        if (this.discardChecker == null) {
            return false;
        }
        if (this.discardChecker.isDiscardUndefined() && !attributeValue.isDefined()) {
            return true;
        }
        if (!this.discardChecker.isDiscardExpressions() && attributeValue.getType() == ModelType.EXPRESSION) {
            return false;
        }
        return operation != null ? this.discardChecker.isOperationParameterDiscardable(address, this.name, attributeValue, operation, context.getContext()) : this.discardChecker.isResourceAttributeDiscardable(address, this.name, attributeValue, context.getContext());
    }

    String getNewName() {
        return this.newName;
    }

    void rejectAttributes(RejectedAttributesLogContext rejectedAttributes, ModelNode attributeValue) {
        for (RejectAttributeChecker checker : this.checks) {
            rejectedAttributes.checkAttribute(checker, this.name, attributeValue);
        }
    }

    void isExistingValue(PathAddress address, ModelNode attributeValue, ModelNode operation, TransformationRule.AbstractChainedContext context) {
        if (this.converter != null) {
            if (operation != null) {
                this.converter.convertOperationParameter(address, this.name, attributeValue, operation, context.getContext());
            } else {
                this.converter.convertResourceAttribute(address, this.name, attributeValue, context.getContext());
            }
        }
    }

    void convertValue(PathAddress address, ModelNode attributeValue, ModelNode operation, TransformationRule.AbstractChainedContext context) {
        if (this.converter != null) {
            if (operation != null) {
                this.converter.convertOperationParameter(address, this.name, attributeValue, operation, context.getContext());
            } else {
                this.converter.convertResourceAttribute(address, this.name, attributeValue, context.getContext());
            }
        }
    }
}

