/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.dmr;

import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.ModelValue;
import infinispan.org.jboss.dmr.ValueExpression;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

final class IntModelValue
extends ModelValue {
    private final int value;

    IntModelValue(int value) {
        super(ModelType.INT);
        this.value = value;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.write(ModelType.INT.typeChar);
        out.writeInt(this.value);
    }

    @Override
    long asLong() {
        return this.value;
    }

    @Override
    long asLong(long defVal) {
        return this.value;
    }

    @Override
    int asInt() {
        return this.value;
    }

    @Override
    int asInt(int defVal) {
        return this.value;
    }

    @Override
    boolean asBoolean() {
        return this.value != 0;
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return this.value != 0;
    }

    @Override
    double asDouble() {
        return this.value;
    }

    @Override
    double asDouble(double defVal) {
        return this.value;
    }

    @Override
    byte[] asBytes() {
        byte[] bytes = new byte[]{(byte)(this.value >>> 24), (byte)(this.value >>> 16), (byte)(this.value >>> 8), (byte)this.value};
        return bytes;
    }

    @Override
    BigDecimal asBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    String asString() {
        return Integer.toString(this.value);
    }

    @Override
    ValueExpression asExpression() {
        return new ValueExpression(this.asString());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof IntModelValue && this.equals((IntModelValue)other);
    }

    public boolean equals(IntModelValue other) {
        return this == other || other != null && this.value == other.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }
}

