/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules.filter;

import infinispan.org.jboss.modules.filter.MultiplePathFilter;
import infinispan.org.jboss.modules.filter.PathFilter;
import infinispan.org.jboss.modules.filter.PathFilters;
import java.util.ArrayList;
import java.util.List;

public class MultiplePathFilterBuilder {
    private final List<PathFilter> filters = new ArrayList<PathFilter>();
    private final List<Boolean> includeFlags = new ArrayList<Boolean>();
    private final boolean defaultVal;

    MultiplePathFilterBuilder(boolean defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void addFilter(PathFilter filter, boolean include) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.filters.add(filter);
        this.includeFlags.add(include);
    }

    public PathFilter create() {
        PathFilter[] filters = this.filters.toArray(new PathFilter[this.filters.size()]);
        boolean[] includeFlags = new boolean[this.includeFlags.size()];
        int includeFlagsSize = this.includeFlags.size();
        for (int i = 0; i < includeFlagsSize; ++i) {
            includeFlags[i] = this.includeFlags.get(i);
        }
        if (filters.length == 0) {
            return this.defaultVal ? PathFilters.acceptAll() : PathFilters.rejectAll();
        }
        return new MultiplePathFilter(filters, includeFlags, this.defaultVal);
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }
}

