/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.modules.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ArtifactCoordinates {
    static final Pattern snapshotPattern = Pattern.compile("-\\d{8}\\.\\d{6}-\\d+$");
    private static final Pattern VALID_PATTERN = Pattern.compile("^([-_a-zA-Z0-9.]+):([-_a-zA-Z0-9.]+):([-_a-zA-Z0-9.]+)(?::([-_a-zA-Z0-9.]+))?$");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private int hashCode;
    private String toString;

    public ArtifactCoordinates(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public ArtifactCoordinates(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "");
    }

    public static ArtifactCoordinates fromString(String string) {
        Matcher matcher = VALID_PATTERN.matcher(string);
        if (matcher.matches()) {
            if (matcher.group(4) != null) {
                return new ArtifactCoordinates(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
            }
            return new ArtifactCoordinates(matcher.group(1), matcher.group(2), matcher.group(3));
        }
        throw new IllegalArgumentException(string);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String relativeArtifactPath(char separator) {
        String artifactId1 = this.getArtifactId();
        String version1 = this.getVersion();
        StringBuilder builder = new StringBuilder(this.getGroupId().replace('.', separator));
        builder.append(separator).append(artifactId1).append(separator);
        Matcher versionMatcher = snapshotPattern.matcher(version1);
        String pathVersion = versionMatcher.find() ? version1.substring(0, versionMatcher.start()) + "-SNAPSHOT" : version1;
        builder.append(pathVersion).append(separator).append(artifactId1).append('-').append(version1);
        return builder.toString();
    }

    public String relativeArtifactPath() {
        return this.relativeArtifactPath('/');
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ArtifactCoordinates && this.equals((ArtifactCoordinates)obj);
    }

    public boolean equals(ArtifactCoordinates obj) {
        return this == obj || obj != null && this.groupId.equals(obj.groupId) && this.artifactId.equals(obj.artifactId) && this.version.equals(obj.version) && this.classifier.equals(obj.classifier);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = ((this.groupId.hashCode() * 19 + this.artifactId.hashCode()) * 19 + this.version.hashCode()) * 19 + this.classifier.hashCode();
            if (hashCode == 0) {
                hashCode = -1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            StringBuilder b = new StringBuilder(this.groupId.length() + this.artifactId.length() + this.version.length() + this.classifier.length() + 16);
            b.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
            if (!this.classifier.isEmpty()) {
                b.append(':').append(this.classifier);
            }
            this.toString = toString = b.toString();
        }
        return toString;
    }
}

