/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.AttributeMarshallers;
import infinispan.org.jboss.as.controller.DefaultAttributeMarshaller;
import infinispan.org.jboss.as.controller.ObjectListAttributeDefinition;
import infinispan.org.jboss.as.controller.ObjectTypeAttributeDefinition;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AttributeMarshaller {
    public static final AttributeMarshaller SIMPLE = new DefaultAttributeMarshaller();
    public static final AttributeMarshaller STRING_LIST = new ListMarshaller(' ');
    public static final AttributeMarshaller COMMA_STRING_LIST = new ListMarshaller(',');
    public static final AttributeMarshaller ELEMENT_ONLY_OBJECT = new ObjectMarshaller(true);
    public static final AttributeMarshaller ATTRIBUTE_OBJECT = new ObjectMarshaller(false);
    public static final AttributeMarshaller OBJECT_LIST_MARSHALLER = new ObjectListMarshaller();
    public static final AttributeMarshaller PROPERTIES_MARSHALLER = new AttributeMarshallers.PropertiesAttributeMarshaller();
    public static final AttributeMarshaller PROPERTIES_MARSHALLER_UNWRAPPED = new AttributeMarshallers.PropertiesAttributeMarshaller(null, false);

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel) {
        return this.isMarshallable(attribute, resourceModel, true);
    }

    public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
        return resourceModel.hasDefined(attribute.getName()) && (marshallDefault || !resourceModel.get(attribute.getName()).equals(attribute.getDefaultValue()));
    }

    public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsAttribute(attribute.getName());
    }

    public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.couldNotMarshalAttributeAsElement(attribute.getName());
    }

    public boolean isMarshallableAsElement() {
        return false;
    }

    public void marshall(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.isMarshallableAsElement()) {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        } else {
            this.marshallAsAttribute(attribute, resourceModel, marshallDefault, writer);
        }
    }

    private static class ObjectListMarshaller
    extends AttributeMarshaller {
        private ObjectListMarshaller() {
        }

        @Override
        public boolean isMarshallableAsElement() {
            return true;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            assert (attribute instanceof ObjectListAttributeDefinition);
            ObjectListAttributeDefinition list = (ObjectListAttributeDefinition)attribute;
            ObjectTypeAttributeDefinition objectType = list.getValueType();
            AttributeDefinition[] valueTypes = objectType.getValueTypes();
            if (resourceModel.hasDefined(attribute.getName())) {
                List<ModelNode> elements = resourceModel.get(attribute.getName()).asList();
                if (elements.isEmpty()) {
                    writer.writeEmptyElement(attribute.getXmlName());
                } else {
                    writer.writeStartElement(attribute.getXmlName());
                    for (ModelNode element : elements) {
                        writer.writeStartElement(objectType.getXmlName());
                        for (AttributeDefinition valueType : valueTypes) {
                            valueType.getAttributeMarshaller().marshall(valueType, element, false, writer);
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
        }
    }

    private static class ObjectMarshaller
    extends DefaultAttributeMarshaller {
        private final boolean marshallSimpleTypeAsElement;

        private ObjectMarshaller(boolean marshallSimpleTypeAsAttribute) {
            this.marshallSimpleTypeAsElement = marshallSimpleTypeAsAttribute;
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            assert (attribute instanceof ObjectTypeAttributeDefinition);
            if (resourceModel.hasDefined(attribute.getName())) {
                AttributeDefinition[] valueTypes = ((ObjectTypeAttributeDefinition)attribute).getValueTypes();
                writer.writeStartElement(attribute.getXmlName());
                for (AttributeDefinition valueType : valueTypes) {
                    if (!resourceModel.hasDefined(attribute.getName(), valueType.getName())) continue;
                    ModelNode handler = resourceModel.get(attribute.getName());
                    if (this.marshallSimpleTypeAsElement) {
                        valueType.marshallAsElement(handler, marshallDefault, writer);
                        continue;
                    }
                    valueType.getAttributeMarshaller().marshallAsAttribute(valueType, handler, marshallDefault, writer);
                }
                writer.writeEndElement();
            }
        }

        @Override
        public boolean isMarshallableAsElement() {
            return !this.marshallSimpleTypeAsElement;
        }
    }

    private static class ListMarshaller
    extends DefaultAttributeMarshaller {
        private final char delimiter;

        ListMarshaller(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        protected String asString(ModelNode value) {
            StringBuilder builder = new StringBuilder();
            Iterator<ModelNode> values = value.asList().iterator();
            while (values.hasNext()) {
                builder.append(values.next().asString());
                if (!values.hasNext()) continue;
                builder.append(this.delimiter);
            }
            return builder.toString();
        }
    }
}

