/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access.constraint;

import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.JmxAction;
import infinispan.org.jboss.as.controller.access.JmxTarget;
import infinispan.org.jboss.as.controller.access.TargetAttribute;
import infinispan.org.jboss.as.controller.access.TargetResource;
import infinispan.org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import infinispan.org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import infinispan.org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import infinispan.org.jboss.as.controller.access.constraint.Constraint;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintDefinition;
import infinispan.org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import infinispan.org.jboss.as.controller.access.rbac.StandardRole;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApplicationTypeConstraint
extends AllowAllowNotConstraint {
    public static final Factory FACTORY = new Factory();
    private static final ApplicationTypeConstraint APPLICATION = new ApplicationTypeConstraint(true);
    private static final ApplicationTypeConstraint NON_APPLICATION = new ApplicationTypeConstraint(false);

    private ApplicationTypeConstraint(boolean isApplication) {
        super(isApplication);
    }

    private ApplicationTypeConstraint(boolean allowsApplication, boolean allowsNonApplication) {
        super(allowsApplication, allowsNonApplication);
    }

    public static class Factory
    extends AbstractConstraintFactory {
        private final Map<ApplicationTypeConfig.Key, ApplicationTypeConfig> typeConfigs = Collections.synchronizedMap(new HashMap());

        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            boolean allowsNonApplication = role != StandardRole.DEPLOYER || actionEffect != Action.ActionEffect.WRITE_CONFIG && actionEffect != Action.ActionEffect.WRITE_RUNTIME;
            return new ApplicationTypeConstraint(true, allowsNonApplication);
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.isApplicationType(target.getTargetResource()) || this.isApplicationType(action) || this.isApplicationType(target) ? APPLICATION : NON_APPLICATION;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isApplicationType(action) || this.isApplicationType(target) ? APPLICATION : NON_APPLICATION;
        }

        private boolean isApplicationType(Action action) {
            for (AccessConstraintDefinition constraintDefinition : action.getAccessConstraints()) {
                ApplicationTypeAccessConstraintDefinition atcd;
                ApplicationTypeConfig atc;
                if (!(constraintDefinition instanceof ApplicationTypeAccessConstraintDefinition) || !(atc = (atcd = (ApplicationTypeAccessConstraintDefinition)constraintDefinition).getApplicationTypeConfig()).isApplicationType()) continue;
                return true;
            }
            return false;
        }

        private boolean isApplicationType(TargetAttribute target) {
            for (AccessConstraintDefinition constraintDefinition : target.getAccessConstraints()) {
                ApplicationTypeAccessConstraintDefinition atcd;
                ApplicationTypeConfig atc;
                if (!(constraintDefinition instanceof ApplicationTypeAccessConstraintDefinition) || !(atc = (atcd = (ApplicationTypeAccessConstraintDefinition)constraintDefinition).getApplicationTypeConfig()).isApplicationType()) continue;
                return true;
            }
            return false;
        }

        private boolean isApplicationType(TargetResource target) {
            for (AccessConstraintDefinition constraintDefinition : target.getAccessConstraints()) {
                ApplicationTypeAccessConstraintDefinition atcd;
                ApplicationTypeConfig atc;
                if (!(constraintDefinition instanceof ApplicationTypeAccessConstraintDefinition) || !(atc = (atcd = (ApplicationTypeAccessConstraintDefinition)constraintDefinition).getApplicationTypeConfig()).isApplicationType()) continue;
                return true;
            }
            return false;
        }

        public void addApplicationTypeConfig(ApplicationTypeConfig applicationTypeConfig) {
            ApplicationTypeConfig.Key key = applicationTypeConfig.getKey();
            ApplicationTypeConfig existing = this.typeConfigs.get(key);
            if (existing == null) {
                this.typeConfigs.put(key, applicationTypeConfig);
            } else assert (existing.isCompatibleWith(applicationTypeConfig)) : "incompatible " + applicationTypeConfig.getClass().getSimpleName();
        }

        public Collection<ApplicationTypeConfig> getApplicationTypeConfigs() {
            return Collections.unmodifiableCollection(this.typeConfigs.values());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return 0;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return NON_APPLICATION;
        }
    }
}

