/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client.helpers.domain.impl;

import infinispan.org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import infinispan.org.jboss.as.controller.client.helpers.domain.DeploymentActionResult;
import infinispan.org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import infinispan.org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import infinispan.org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import infinispan.org.jboss.as.controller.client.helpers.domain.UpdateFailedException;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.BasicDomainUpdateResult;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.DeploymentActionResultImpl;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanImpl;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanResultImpl;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.ServerUpdateResultImpl;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.UpdateResultHandlerResponse;
import infinispan.org.jboss.as.controller.client.logging.ControllerClientLogger;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DomainDeploymentPlanResultFuture
implements Future<DeploymentPlanResult> {
    private static final String DOMAIN_FAILURE_DESCRIPTION = "domain-failure-description";
    private static final String HOST_FAILURE_DESCRIPTION = "host-failure-description";
    private static final String ROLLED_BACK = "rolled-back";
    private final Future<ModelNode> nodeFuture;
    private final DeploymentPlanImpl plan;
    private final Map<UUID, List<String>> actionsById;
    private final Set<ServerIdentity> servers;

    DomainDeploymentPlanResultFuture(DeploymentPlanImpl plan, Future<ModelNode> nodeFuture, Set<ServerIdentity> servers, Map<UUID, List<String>> actionsById) {
        this.plan = plan;
        this.nodeFuture = nodeFuture;
        this.actionsById = actionsById;
        this.servers = servers;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.nodeFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.nodeFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.nodeFuture.isDone();
    }

    @Override
    public DeploymentPlanResult get() throws InterruptedException, ExecutionException {
        ModelNode node = this.nodeFuture.get();
        return this.getResultFromNode(node);
    }

    @Override
    public DeploymentPlanResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ModelNode node = this.nodeFuture.get(timeout, unit);
        return this.getResultFromNode(node);
    }

    private DeploymentPlanResult getResultFromNode(ModelNode planResultNode) {
        HashMap<UUID, DeploymentActionResult> actionResults = new HashMap<UUID, DeploymentActionResult>();
        String outcome = planResultNode.get("outcome").asString();
        if ("cancelled".equals(outcome)) {
            this.createCancelledResults(actionResults);
        } else if ("success".equals(outcome)) {
            this.createSuccessResults(actionResults, planResultNode);
        } else {
            this.createFailureResults(actionResults, planResultNode);
        }
        return new DeploymentPlanResultImpl((DeploymentPlan)this.plan, actionResults);
    }

    private void createFailureResults(Map<UUID, DeploymentActionResult> actionResults, ModelNode planResultNode) {
        boolean isDomainFailure = false;
        boolean isHostFailure = false;
        if (planResultNode.hasDefined("failure-description")) {
            ModelNode failureDescription = planResultNode.get("failure-description");
            isDomainFailure = failureDescription.hasDefined(DOMAIN_FAILURE_DESCRIPTION);
            isHostFailure = failureDescription.hasDefined(HOST_FAILURE_DESCRIPTION);
        }
        ModelNode result = planResultNode.get("result");
        for (DeploymentAction deploymentAction : this.plan.getDeploymentActions()) {
            List<String> steps = this.actionsById.get(deploymentAction.getId());
            for (String step : steps) {
                BasicDomainUpdateResult domainUpdateResult;
                boolean isRolledBack;
                if (!result.hasDefined(step)) continue;
                ModelNode stepResult = result.get(step);
                boolean bl = isRolledBack = stepResult.hasDefined(ROLLED_BACK) && stepResult.get(ROLLED_BACK).asBoolean();
                UpdateFailedException updateFailedException = stepResult.hasDefined("failure-description") ? new UpdateFailedException(stepResult.get("failure-description").toString()) : (planResultNode.hasDefined("failure-description") ? new UpdateFailedException(planResultNode.get("failure-description").toString()) : new UpdateFailedException(ControllerClientLogger.ROOT_LOGGER.noFailureDetails()));
                if (isDomainFailure) {
                    domainUpdateResult = new BasicDomainUpdateResult(updateFailedException, isRolledBack);
                } else if (isHostFailure) {
                    HashMap<String, UpdateFailedException> hostExceptions = new HashMap<String, UpdateFailedException>();
                    for (ServerIdentity serverId : this.servers) {
                        hostExceptions.put(serverId.getHostName(), updateFailedException);
                    }
                    domainUpdateResult = new BasicDomainUpdateResult(hostExceptions, isRolledBack);
                } else {
                    domainUpdateResult = new BasicDomainUpdateResult();
                }
                DeploymentActionResultImpl deploymentActionResult = new DeploymentActionResultImpl(deploymentAction, domainUpdateResult);
                UpdateResultHandlerResponse resultHandlerResponse = UpdateResultHandlerResponse.createFailureResponse(updateFailedException);
                for (ServerIdentity serverId : this.servers) {
                    ServerUpdateResultImpl serverUpdateResult = new ServerUpdateResultImpl(deploymentAction.getId(), serverId, resultHandlerResponse);
                    deploymentActionResult.storeServerUpdateResult(serverId, serverUpdateResult);
                }
                actionResults.put(deploymentAction.getId(), deploymentActionResult);
            }
        }
    }

    private void createSuccessResults(Map<UUID, DeploymentActionResult> actionResults, ModelNode planResultNode) {
        this.createDefaultResults(actionResults, new BasicDomainUpdateResult(), UpdateResultHandlerResponse.createSuccessResponse(planResultNode));
    }

    private void createCancelledResults(Map<UUID, DeploymentActionResult> actionResults) {
        this.createDefaultResults(actionResults, new BasicDomainUpdateResult(true), UpdateResultHandlerResponse.createCancellationResponse());
    }

    private void createDefaultResults(Map<UUID, DeploymentActionResult> actionResults, BasicDomainUpdateResult domainUpdateResult, UpdateResultHandlerResponse resultHandlerResponse) {
        for (DeploymentAction deploymentAction : this.plan.getDeploymentActions()) {
            DeploymentActionResultImpl deploymentActionResult = new DeploymentActionResultImpl(deploymentAction, domainUpdateResult);
            for (ServerIdentity serverId : this.servers) {
                ServerUpdateResultImpl serverUpdateResult = new ServerUpdateResultImpl(deploymentAction.getId(), serverId, resultHandlerResponse);
                deploymentActionResult.storeServerUpdateResult(serverId, serverUpdateResult);
            }
            actionResults.put(deploymentAction.getId(), deploymentActionResult);
        }
    }
}

