/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client.impl;

import infinispan.org.jboss.as.controller.client.logging.ControllerClientLogger;
import infinispan.org.jboss.as.protocol.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public interface InputStreamEntry
extends Closeable {
    public static final InputStreamEntry EMPTY = new InputStreamEntry(){

        @Override
        public int initialize() throws IOException {
            return 0;
        }

        @Override
        public void copyStream(DataOutput output) throws IOException {
            output.write(new byte[0]);
        }

        @Override
        public void close() throws IOException {
        }
    };

    public int initialize() throws IOException;

    public void copyStream(DataOutput var1) throws IOException;

    public static class CachingStreamEntry
    implements InputStreamEntry {
        private final boolean autoClose;
        private final InputStream original;
        private File temp;

        public CachingStreamEntry(InputStream original, boolean autoClose) {
            this.original = original;
            this.autoClose = autoClose;
        }

        @Override
        public synchronized int initialize() throws IOException {
            if (this.temp == null) {
                this.temp = File.createTempFile("client", "stream");
                FileOutputStream os = new FileOutputStream(this.temp);
                try {
                    StreamUtils.copyStream(this.original, os);
                    os.flush();
                    os.close();
                }
                finally {
                    StreamUtils.safeClose(os);
                    if (this.autoClose) {
                        StreamUtils.safeClose(this.original);
                    }
                }
            }
            return (int)this.temp.length();
        }

        @Override
        public synchronized void copyStream(DataOutput output) throws IOException {
            FileInputStream is = new FileInputStream(this.temp);
            try {
                StreamUtils.copyStream((InputStream)is, output);
            }
            finally {
                StreamUtils.safeClose(is);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.temp.delete()) {
                ControllerClientLogger.ROOT_LOGGER.cannotDeleteTempFile(this.temp.getName());
                this.temp.deleteOnExit();
            }
            this.temp = null;
        }
    }

    public static class InMemoryEntry
    implements InputStreamEntry {
        private final boolean autoClose;
        private final InputStream original;
        private byte[] data;

        public InMemoryEntry(InputStream original, boolean autoClose) {
            this.original = original;
            this.autoClose = autoClose;
        }

        @Override
        public synchronized int initialize() throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                StreamUtils.copyStream(this.original, os);
            }
            finally {
                if (this.autoClose) {
                    StreamUtils.safeClose(this.original);
                }
            }
            this.data = os.toByteArray();
            return this.data.length;
        }

        @Override
        public synchronized void copyStream(DataOutput output) throws IOException {
            try {
                output.write(this.data);
            }
            finally {
                this.data = null;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

