/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinition;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.access.AuthorizationResult;
import infinispan.org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.persistence.ConfigurationPersister;
import infinispan.org.jboss.as.controller.registry.OperationEntry;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;

public class SnapshotDeleteHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "delete-snapshot";
    private static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowNull(false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("delete-snapshot", ControllerResolver.getResolver("snapshot")).setParameters(NAME).setRuntimeOnly().withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SNAPSHOTS).build();
    private final ConfigurationPersister persister;

    public SnapshotDeleteHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationResult authorizationResult = context.authorize(operation);
        if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.get("operation").asString(), context.getCurrentAddress(), authorizationResult.getExplanation());
        }
        String name = operation.require("name").asString();
        try {
            this.persister.deleteSnapshot(name);
        }
        catch (Exception e) {
            throw new OperationFailedException(e);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

