/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationDefinition;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.AuthorizationResult;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Collections;
import java.util.Iterator;

public class ValidateAddressOperationHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "validate-address";
    public static final ValidateAddressOperationHandler INSTANCE = new ValidateAddressOperationHandler();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("validate-address", ControllerResolver.getResolver("global")).addParameter(SimpleAttributeDefinitionBuilder.create("value", ModelType.OBJECT).build()).setReplyParameters(SimpleAttributeDefinitionBuilder.create("valid", ModelType.BOOLEAN).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("problem", ModelType.STRING).setAllowNull(true)).build()).setReadOnly().build();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource;
        ModelNode address = operation.require("value");
        PathAddress pathAddr = PathAddress.pathAddress(address);
        Resource model = resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Iterator iterator = pathAddr.iterator();
        PathAddress current = PathAddress.EMPTY_ADDRESS;
        while (iterator.hasNext()) {
            PathElement next = (PathElement)iterator.next();
            current = current.append(next);
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(current);
            if (registration != null && registration.isRemote()) {
                if (!iterator.hasNext()) break;
                PathAddress newAddress = pathAddr.subAddress(current.size());
                ModelNode newOperation = operation.clone();
                newOperation.get("address").set(current.toModelNode());
                newOperation.get("value").set(newAddress.toModelNode());
                OperationStepHandler proxyHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, OPERATION_NAME);
                if (proxyHandler == null) continue;
                context.addStep(newOperation, proxyHandler, OperationContext.Stage.MODEL, true);
                return;
            }
            if (model.hasChild(next)) {
                model = model.getChild(next);
                continue;
            }
            context.getResult().get("valid").set(false);
            context.getResult().get("problem").set(ControllerLogger.ROOT_LOGGER.childResourceNotFound(next));
            return;
        }
        if (this.authorize(context, current, operation).getDecision() == AuthorizationResult.Decision.DENY) {
            context.getResult().get("valid").set(false);
            context.getResult().get("problem").set(ControllerLogger.ROOT_LOGGER.managementResourceNotFoundMessage(current));
        } else {
            context.getResult().get("valid").set(true);
        }
    }

    private AuthorizationResult authorize(OperationContext context, PathAddress address, ModelNode operation) {
        ModelNode authOp = operation.clone();
        authOp.get("operation").set("read-resource");
        authOp.get("address").set(address.toModelNode());
        return context.authorize(authOp, Collections.singleton(Action.ActionEffect.ADDRESS));
    }
}

