/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.MinMaxValidator;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;

public class BytesValidator
extends ModelTypeValidator
implements MinMaxValidator {
    private final int min;
    private final int max;

    public static final BytesValidator createSha1(boolean nullable) {
        return new BytesValidator(20, 20, nullable);
    }

    public BytesValidator(int min, int max, boolean nullable) {
        super(ModelType.BYTES, nullable);
        this.min = min;
        this.max = max;
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            byte[] val = value.asBytes();
            if (val.length < this.min) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinSize(val.length, parameterName, this.min));
            }
            if (val.length > this.max) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMaxSize(val.length, parameterName, this.max));
            }
        }
    }
}

