/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressValidator
extends ModelTypeValidator {
    public InetAddressValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions, true);
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String str = value.asString();
            try {
                InetAddress.getByName(str);
            }
            catch (UnknownHostException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }
}

