/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.as.controller.operations.validation.ParameterValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.HashSet;
import java.util.List;

public class ListValidator
extends ModelTypeValidator
implements ParameterValidator {
    private final int min;
    private final int max;
    private final ParameterValidator elementValidator;
    private final boolean allowDuplicates;

    public ListValidator(ParameterValidator elementValidator) {
        this(elementValidator, false, 1, Integer.MAX_VALUE, false);
    }

    public ListValidator(ParameterValidator elementValidator, boolean nullable) {
        this(elementValidator, nullable, 1, Integer.MAX_VALUE, false);
    }

    public ListValidator(ParameterValidator elementValidator, boolean nullable, boolean allowDuplicates) {
        this(elementValidator, nullable, 1, Integer.MAX_VALUE, allowDuplicates);
    }

    public ListValidator(ParameterValidator elementValidator, boolean nullable, int minSize, int maxSize) {
        this(elementValidator, nullable, minSize, maxSize, true);
    }

    public ListValidator(ParameterValidator elementValidator, boolean nullable, int minSize, int maxSize, boolean allowDuplicates) {
        super(ModelType.LIST, nullable, false, true);
        if (elementValidator == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("elementValidator");
        }
        this.min = minSize;
        this.max = maxSize;
        this.elementValidator = elementValidator;
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            List<ModelNode> list = value.asList();
            int size = list.size();
            if (size < this.min) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinSize(size, parameterName, this.min));
            }
            if (size > this.max) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMaxSize(size, parameterName, this.max));
            }
            if (!this.allowDuplicates) {
                HashSet<ModelNode> dups = new HashSet<ModelNode>();
                for (ModelNode element : list) {
                    if (dups.add(element)) continue;
                    throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.duplicateElementsInList(parameterName));
                }
                dups.clear();
            }
            for (ModelNode element : list) {
                this.elementValidator.validateParameter(parameterName, element);
            }
        }
    }
}

