/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.validation;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.validation.ModelTypeValidator;
import infinispan.org.jboss.as.controller.operations.validation.ParameterValidator;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.Property;
import java.util.List;

public class MapValidator
extends ModelTypeValidator
implements ParameterValidator {
    private final int min;
    private final int max;
    private final ParameterValidator elementValidator;

    public MapValidator(ParameterValidator elementValidator) {
        this(elementValidator, false, 1, Integer.MAX_VALUE);
    }

    public MapValidator(ParameterValidator elementValidator, boolean nullable) {
        this(elementValidator, nullable, 1, Integer.MAX_VALUE);
    }

    public MapValidator(ParameterValidator elementValidator, boolean nullable, int minSize, int maxSize) {
        super(ModelType.OBJECT, nullable, false, false);
        if (elementValidator == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("elementValidator");
        }
        this.min = minSize;
        this.max = maxSize;
        this.elementValidator = elementValidator;
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            List<Property> list = value.asPropertyList();
            int size = list.size();
            if (size < this.min) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMinSize(size, parameterName, this.min));
            }
            if (size > this.max) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidMaxSize(size, parameterName, this.max));
            }
            for (Property property : list) {
                this.elementValidator.validateParameter(parameterName, property.getValue());
            }
        }
    }
}

