/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.parsing;

import infinispan.org.jboss.as.controller.parsing.Attribute;
import infinispan.org.jboss.as.controller.parsing.Element;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class WriteUtils {
    private static final char[] NEW_LINE = new char[]{'\n'};

    private WriteUtils() {
    }

    public static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attribute, String value) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    public static void writeElement(XMLExtendedStreamWriter writer, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
    }

    public static void writeSingleElement(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel) throws XMLStreamException {
        writer.writeEmptyElement(element.getLocalName());
        WriteUtils.writeAttribute(writer, attribute, subModel.asString());
    }

    public static void writeListAsMultipleElements(XMLExtendedStreamWriter writer, Element element, Attribute attribute, ModelNode subModel) throws XMLStreamException {
        List<ModelNode> list = subModel.asList();
        for (ModelNode node : list) {
            writer.writeEmptyElement(element.getLocalName());
            WriteUtils.writeAttribute(writer, attribute, node.asString());
        }
    }

    public static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(NEW_LINE, 0, 1);
    }
}

