/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.persistence;

import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import infinispan.org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import infinispan.org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import infinispan.org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import infinispan.org.jboss.as.controller.persistence.FilePersistenceUtils;
import infinispan.org.jboss.dmr.ModelNode;
import java.io.File;

public class FilePersistenceResource
extends AbstractFilePersistenceResource {
    protected final File fileName;

    FilePersistenceResource(ModelNode model, File fileName, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(ExposedByteArrayOutputStream marshalled) {
        File tempFileName = FilePersistenceUtils.createTempFile(this.fileName);
        try {
            FilePersistenceUtils.writeToTempFile(marshalled, tempFileName, this.fileName);
            FilePersistenceUtils.moveTempFileToMain(tempFileName, this.fileName);
        }
        catch (Exception e) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
        }
        finally {
            if (tempFileName.exists() && !tempFileName.delete()) {
                ControllerLogger.MGMT_OP_LOGGER.cannotDeleteTempFile(tempFileName.getName());
                tempFileName.deleteOnExit();
            }
        }
    }
}

