/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.registry;

import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.notification.Notification;
import infinispan.org.jboss.as.controller.notification.NotificationHandler;
import infinispan.org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import infinispan.org.jboss.as.controller.registry.ConcreteNotificationHandlerRegistration;
import infinispan.org.jboss.as.controller.registry.NotificationHandlerNodeRegistry;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class NotificationHandlerNodeSubregistry {
    private final String keyName;
    private final NotificationHandlerNodeRegistry parent;
    private volatile Map<String, NotificationHandlerNodeRegistry> childRegistries;
    private static final AtomicMapFieldUpdater<NotificationHandlerNodeSubregistry, String, NotificationHandlerNodeRegistry> childRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(NotificationHandlerNodeSubregistry.class, Map.class, "childRegistries"));

    NotificationHandlerNodeSubregistry(String keyName, NotificationHandlerNodeRegistry parent) {
        this.keyName = keyName;
        this.parent = parent;
        childRegistriesUpdater.clear(this);
    }

    void registerEntry(ListIterator<PathElement> iterator, String elementValue, ConcreteNotificationHandlerRegistration.NotificationHandlerEntry entry) {
        NotificationHandlerNodeRegistry newRegistry = new NotificationHandlerNodeRegistry(elementValue, this);
        NotificationHandlerNodeRegistry existingRegistry = childRegistriesUpdater.putIfAbsent(this, elementValue, newRegistry);
        NotificationHandlerNodeRegistry registry = existingRegistry != null ? existingRegistry : newRegistry;
        registry.registerEntry(iterator, entry);
    }

    void unregisterEntry(ListIterator<PathElement> iterator, String value, ConcreteNotificationHandlerRegistration.NotificationHandlerEntry entry) {
        NotificationHandlerNodeRegistry registry = this.childRegistries.get(value);
        if (registry == null) {
            return;
        }
        registry.unregisterEntry(iterator, entry);
    }

    void findHandlers(ListIterator<PathElement> iterator, String value, Notification notification, Collection<NotificationHandler> handlers) {
        NotificationHandlerNodeRegistry wildCardRegistry;
        NotificationHandlerNodeRegistry registry = this.childRegistries.get(value);
        if (registry != null) {
            registry.findEntries(iterator, handlers, notification);
        }
        if ((wildCardRegistry = this.childRegistries.get("*")) != null) {
            wildCardRegistry.findEntries(iterator, handlers, notification);
        }
    }

    String getLocationString() {
        return this.parent.getLocationString() + "(" + this.keyName + " => ";
    }
}

