/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.remote;

import infinispan.org.jboss.as.controller.ModelController;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import infinispan.org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import infinispan.org.jboss.threads.JBossThreadFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractModelControllerOperationHandlerFactoryService
implements Service<AbstractModelControllerOperationHandlerFactoryService>,
ManagementChannelInitialization {
    public static final ServiceName OPERATION_HANDLER_NAME_SUFFIX = ServiceName.of("operation", "handler");
    private static final int WORK_QUEUE_SIZE = 512;
    private static final int POOL_CORE_SIZE = 4;
    private static final int POOL_MAX_SIZE = 4;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutor = new InjectedValue();
    private ResponseAttachmentInputStreamSupport responseAttachmentSupport;
    private ExecutorService clientRequestExecutor;

    public InjectedValue<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executor;
    }

    public InjectedValue<ScheduledExecutorService> getScheduledExecutorInjector() {
        return this.scheduledExecutor;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        ControllerLogger.MGMT_OP_LOGGER.debugf("Starting operation handler service %s", (Object)context.getController().getName());
        this.responseAttachmentSupport = new ResponseAttachmentInputStreamSupport(this.scheduledExecutor.getValue());
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(512);
        ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup("management-handler-thread"), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
        ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
        executor.allowCoreThreadTimeOut(true);
        this.clientRequestExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop(final StopContext stopContext) {
        ExecutorService executorService = this.executor.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractModelControllerOperationHandlerFactoryService.this.responseAttachmentSupport.shutdown();
                    AbstractModelControllerOperationHandlerFactoryService.this.clientRequestExecutor.shutdown();
                }
                finally {
                    stopContext.complete();
                }
            }
        };
        try {
            executorService.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            stopContext.asynchronous();
        }
    }

    @Override
    public synchronized AbstractModelControllerOperationHandlerFactoryService getValue() throws IllegalStateException {
        return this;
    }

    protected ModelController getController() {
        return this.modelControllerValue.getValue();
    }

    protected ExecutorService getExecutor() {
        return this.executor.getValue();
    }

    protected ResponseAttachmentInputStreamSupport getResponseAttachmentSupport() {
        return this.responseAttachmentSupport;
    }

    protected final ExecutorService getClientRequestExecutor() {
        return this.clientRequestExecutor;
    }
}

