/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.remoting3.remote;

import infinispan.org.jboss.remoting3.RemotingOptions;
import infinispan.org.jboss.remoting3.Version;
import infinispan.org.jboss.remoting3.remote.Protocol;
import infinispan.org.jboss.remoting3.remote.ProtocolUtils;
import infinispan.org.jboss.remoting3.remote.RemoteConnection;
import infinispan.org.jboss.remoting3.remote.RemoteConnectionHandler;
import infinispan.org.jboss.remoting3.remote.RemoteLogger;
import infinispan.org.jboss.remoting3.remote.RemoteReadListener;
import infinispan.org.jboss.remoting3.security.InetAddressPrincipal;
import infinispan.org.jboss.remoting3.security.SimpleUserInfo;
import infinispan.org.jboss.remoting3.security.UserPrincipal;
import infinispan.org.jboss.remoting3.spi.ConnectionHandler;
import infinispan.org.jboss.remoting3.spi.ConnectionHandlerContext;
import infinispan.org.jboss.remoting3.spi.ConnectionHandlerFactory;
import infinispan.org.jboss.remoting3.spi.ConnectionProviderContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.WrappedChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ClientConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final CallbackHandler callbackHandler;
    private final AccessControlContext accessControlContext;
    private final OptionMap optionMap;
    private final Map<String, String> failedMechs = new LinkedHashMap<String, String>();
    private final Set<String> allowedMechs;
    private final Set<String> disallowedMechs;

    ClientConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, CallbackHandler callbackHandler, AccessControlContext accessControlContext, OptionMap optionMap) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.callbackHandler = callbackHandler;
        this.accessControlContext = accessControlContext;
        this.optionMap = optionMap;
        Sequence<String> allowedMechs = optionMap.get(Options.SASL_MECHANISMS);
        Sequence<String> disallowedMechs = optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        this.allowedMechs = allowedMechs == null ? null : new HashSet<String>(allowedMechs);
        this.disallowedMechs = disallowedMechs == null ? Collections.emptySet() : new HashSet<String>(disallowedMechs);
    }

    @Override
    public void handleEvent(ConnectedMessageChannel channel) {
        this.connection.setReadListener(new Greeting(), true);
    }

    SaslException allMechanismsFailed() {
        StringBuilder b = new StringBuilder();
        b.append("Authentication failed: all available authentication mechanisms failed:");
        for (Map.Entry<String, String> entry : this.failedMechs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            b.append("\n   ").append(key).append(": ").append(value);
        }
        return new SaslException(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCapRequest(String remoteServerName) {
        RemoteLogger.client.trace("Client sending capabilities request");
        Pooled<ByteBuffer> pooledSendBuffer = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = pooledSendBuffer.getResource();
            sendBuffer.put((byte)1);
            ProtocolUtils.writeByte(sendBuffer, 0, 1);
            String localEndpointName = this.connectionProviderContext.getEndpoint().getName();
            if (localEndpointName != null) {
                ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
            }
            ProtocolUtils.writeEmpty(sendBuffer, 4);
            ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
            ProtocolUtils.writeInt(sendBuffer, 6, this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
            ProtocolUtils.writeInt(sendBuffer, 7, this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
            sendBuffer.flip();
            this.connection.setReadListener(new Capabilities(remoteServerName), true);
            this.connection.send(pooledSendBuffer);
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                pooledSendBuffer.free();
            }
        }
    }

    private void saslDispose(SaslClient saslClient) {
        if (saslClient != null) {
            try {
                saslClient.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.client.trace("Failure disposing of SaslClient", e);
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslClient saslClient;
        private final String serverName;
        private final String authorizationID;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslClient saslClient, String serverName, String authorizationID, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslClient = saslClient;
            this.serverName = serverName;
            this.authorizationID = authorizationID;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(final ConnectedMessageChannel channel) {
            final Pooled<ByteBuffer> pooledBuffer = ClientConnectionOpenListener.this.connection.allocate();
            boolean free = true;
            try {
                int res;
                final ByteBuffer buffer = pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    if (free) {
                        pooledBuffer.free();
                    }
                    return;
                }
                if (res == 0) {
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    return;
                }
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        return;
                    }
                    case 3: {
                        RemoteLogger.client.trace("Client received authentication challenge");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    byte[] response;
                                    boolean clientComplete = Authentication.this.saslClient.isComplete();
                                    if (clientComplete) {
                                        ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                        return;
                                    }
                                    byte[] challenge = Buffers.take(buffer, buffer.remaining());
                                    try {
                                        response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                    }
                                    catch (Throwable e) {
                                        String mechanismName = Authentication.this.saslClient.getMechanismName();
                                        RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", (Object)mechanismName, (Object)e);
                                        ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                        ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                        ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                        pooledBuffer.free();
                                        return;
                                    }
                                    RemoteLogger.client.trace("Client sending authentication response");
                                    Pooled<ByteBuffer> pooled = ClientConnectionOpenListener.this.connection.allocate();
                                    boolean ok = false;
                                    try {
                                        ByteBuffer sendBuffer = pooled.getResource();
                                        sendBuffer.put((byte)4);
                                        sendBuffer.put(response);
                                        sendBuffer.flip();
                                        ClientConnectionOpenListener.this.connection.send(pooled);
                                        ok = true;
                                        channel.resumeReads();
                                    }
                                    finally {
                                        if (!ok) {
                                            pooled.free();
                                        }
                                    }
                                    return;
                                }
                                finally {
                                    pooledBuffer.free();
                                }
                            }
                        });
                        free = false;
                        return;
                    }
                    case 5: {
                        RemoteLogger.client.trace("Client received authentication complete");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Object qop;
                                    block11: {
                                        boolean clientComplete = Authentication.this.saslClient.isComplete();
                                        byte[] challenge = Buffers.take(buffer, buffer.remaining());
                                        if (!clientComplete) {
                                            try {
                                                byte[] response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                                if (response != null && response.length > 0) {
                                                    ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                                    ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                                    return;
                                                }
                                                if (Authentication.this.saslClient.isComplete()) break block11;
                                                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Client not complete after processing auth complete message"));
                                            }
                                            catch (Throwable e) {
                                                String mechanismName = Authentication.this.saslClient.getMechanismName();
                                                RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", (Object)mechanismName, (Object)e);
                                                ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.toString());
                                                ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                                ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                                return;
                                            }
                                            ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                            return;
                                        }
                                    }
                                    if ("auth-int".equals(qop = Authentication.this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) || "auth-conf".equals(qop)) {
                                        ClientConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create(Authentication.this.saslClient));
                                    }
                                    ConnectionHandlerFactory connectionHandlerFactory = new ConnectionHandlerFactory(){

                                        @Override
                                        public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                            Collection principals = Authentication.this.definePrincipals();
                                            RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientConnectionOpenListener.this.connection, principals, new SimpleUserInfo(principals), Authentication.this.maxInboundChannels, Authentication.this.maxOutboundChannels, Authentication.this.remoteEndpointName, Authentication.this.behavior);
                                            ClientConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ClientConnectionOpenListener.this.connection), false);
                                            ClientConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                            return connectionHandler;
                                        }
                                    };
                                    ClientConnectionOpenListener.this.connection.getResult().setResult(connectionHandlerFactory);
                                    channel.resumeReads();
                                    return;
                                }
                                finally {
                                    pooledBuffer.free();
                                }
                            }
                        });
                        free = false;
                        return;
                    }
                    case 6: {
                        String mechanismName = this.saslClient.getMechanismName();
                        RemoteLogger.client.debugf("Client received authentication rejected for mechanism %s", (Object)mechanismName);
                        ClientConnectionOpenListener.this.failedMechs.put(mechanismName, "Server rejected authentication");
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                return;
            }
            finally {
                if (free) {
                    pooledBuffer.free();
                }
            }
        }

        private Collection<Principal> definePrincipals() {
            ConnectedMessageChannel channel;
            InetSocketAddress address;
            SSLSession session;
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            SslChannel sslChannel = ClientConnectionOpenListener.this.connection.getSslChannel();
            if (sslChannel != null && (session = sslChannel.getSslSession()) != null) {
                try {
                    principals.add(session.getPeerPrincipal());
                }
                catch (SSLPeerUnverifiedException ignored) {
                    // empty catch block
                }
            }
            if (this.authorizationID != null) {
                principals.add(new UserPrincipal(this.authorizationID));
            }
            if ((address = (channel = ClientConnectionOpenListener.this.connection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
                principals.add(new InetAddressPrincipal(address.getAddress()));
            }
            return principals;
        }
    }

    final class StartTls
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        StartTls(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", (Object)receiveBuffer);
                receiveBuffer.flip();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 7: {
                        RemoteLogger.client.trace("Client received STARTTLS response");
                        ConnectedMessageChannel c = channel;
                        while (true) {
                            if (c instanceof SslChannel) {
                                ClientConnectionOpenListener.this.connection.send(RemoteConnection.STARTTLS_SENTINEL);
                                ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                                return;
                            }
                            if (!(c instanceof WrappedChannel)) break;
                            c = ((WrappedChannel)((Object)c)).getChannel();
                        }
                        ClientConnectionOpenListener.this.connection.handleException(new IOException("Client starting STARTTLS but channel doesn't support SSL"));
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Capabilities
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        Capabilities(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                receiveBuffer.flip();
                boolean starttls = false;
                LinkedHashSet<String> serverSaslMechs = new LinkedHashSet<String>();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 1: {
                        RemoteLogger.client.trace("Client received capabilities response");
                        String remoteEndpointName = null;
                        int version = 1;
                        int behavior = 2;
                        boolean useDefaultChannels = true;
                        int channelsIn = 40;
                        int channelsOut = 40;
                        block40: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice(receiveBuffer, len);
                            switch (type) {
                                case 0: {
                                    version = data.get() & 0xFF;
                                    RemoteLogger.client.tracef("Client received capability: version %d", (Object)(version & 0xFF));
                                    continue block40;
                                }
                                case 1: {
                                    String mechName = Buffers.getModifiedUtf8(data);
                                    RemoteLogger.client.tracef("Client received capability: SASL mechanism %s", (Object)mechName);
                                    if (ClientConnectionOpenListener.this.failedMechs.containsKey(mechName) || ClientConnectionOpenListener.this.disallowedMechs.contains(mechName) || ClientConnectionOpenListener.this.allowedMechs != null && !ClientConnectionOpenListener.this.allowedMechs.contains(mechName)) continue block40;
                                    RemoteLogger.client.tracef("SASL mechanism %s added to allowed set", (Object)mechName);
                                    serverSaslMechs.add(mechName);
                                    continue block40;
                                }
                                case 2: {
                                    RemoteLogger.client.trace("Client received capability: STARTTLS");
                                    starttls = true;
                                    continue block40;
                                }
                                case 3: {
                                    remoteEndpointName = Buffers.getModifiedUtf8(data);
                                    RemoteLogger.client.tracef("Client received capability: remote endpoint name \"%s\"", (Object)remoteEndpointName);
                                    continue block40;
                                }
                                case 4: {
                                    behavior |= 1;
                                    behavior &= 0xFFFFFFFD;
                                    RemoteLogger.client.tracef("Client received capability: message close protocol supported", new Object[0]);
                                    continue block40;
                                }
                                case 5: {
                                    behavior &= 0xFFFFFFFD;
                                    String remoteVersionString = Buffers.getModifiedUtf8(data);
                                    RemoteLogger.client.tracef("Client received capability: remote version is \"%s\"", (Object)remoteVersionString);
                                    continue block40;
                                }
                                case 6: {
                                    useDefaultChannels = false;
                                    channelsOut = ProtocolUtils.readIntData(data, len);
                                    RemoteLogger.client.tracef("Client received capability: remote channels in is \"%d\"", (Object)channelsOut);
                                    continue block40;
                                }
                                case 7: {
                                    useDefaultChannels = false;
                                    channelsIn = ProtocolUtils.readIntData(data, len);
                                    RemoteLogger.client.tracef("Client received capability: remote channels out is \"%d\"", (Object)channelsIn);
                                    continue block40;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown capability %02x", (Object)(type & 0xFF));
                        }
                        if (useDefaultChannels) {
                            channelsIn = 40;
                            channelsOut = 40;
                        }
                        if (starttls && ClientConnectionOpenListener.this.optionMap.get(Options.SSL_STARTTLS, true)) {
                            Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                            boolean ok = false;
                            try {
                                ByteBuffer sendBuffer = pooledSendBuffer.getResource();
                                sendBuffer.put((byte)7);
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.setReadListener(new StartTls(this.remoteServerName), true);
                                ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                ok = true;
                                return;
                            }
                            finally {
                                if (!ok) {
                                    pooledSendBuffer.free();
                                }
                            }
                        }
                        if (serverSaslMechs.isEmpty()) break;
                        ArrayList<String> saslMechs = new ArrayList<String>(serverSaslMechs.size());
                        if (ClientConnectionOpenListener.this.allowedMechs != null) {
                            saslMechs.addAll(ClientConnectionOpenListener.this.allowedMechs);
                            saslMechs.retainAll(serverSaslMechs);
                        } else {
                            saslMechs.addAll(serverSaslMechs);
                        }
                        OptionMap optionMap = ClientConnectionOpenListener.this.connection.getOptionMap();
                        final String userName = optionMap.get(RemotingOptions.AUTHORIZE_ID);
                        final Map<String, Object> propertyMap = SaslUtils.createPropertyMap(optionMap, Channels.getOption((Configurable)channel, Options.SECURE, false));
                        SaslClient saslClient = null;
                        Iterator<SaslClientFactory> iterator = AccessController.doPrivileged(new PrivilegedAction<Iterator<SaslClientFactory>>(){

                            @Override
                            public Iterator<SaslClientFactory> run() {
                                return SaslUtils.getSaslClientFactories(this.getClass().getClassLoader(), true);
                            }
                        });
                        LinkedHashMap<String, LinkedHashSet<SaslClientFactory>> factories = new LinkedHashMap<String, LinkedHashSet<SaslClientFactory>>();
                        while (iterator.hasNext()) {
                            SaslClientFactory factory = iterator.next();
                            for (String name : factory.getMechanismNames(propertyMap)) {
                                if (!factories.containsKey(name)) {
                                    factories.put(name, new LinkedHashSet<SaslClientFactory>(Collections.singleton(factory)));
                                    continue;
                                }
                                ((Set)factories.get(name)).add(factory);
                            }
                        }
                        block43: for (String mechanism : saslMechs) {
                            String remoteServerName;
                            Set factorySet = (Set)factories.get(mechanism);
                            final String protocol = optionMap.contains(RemotingOptions.SASL_PROTOCOL) ? optionMap.get(RemotingOptions.SASL_PROTOCOL) : "remoting";
                            String string = remoteServerName = optionMap.contains(RemotingOptions.SERVER_NAME) ? optionMap.get(RemotingOptions.SERVER_NAME) : this.remoteServerName;
                            if (factorySet == null) continue;
                            final String[] strings = new String[]{mechanism};
                            for (final SaslClientFactory factory : factorySet) {
                                try {
                                    saslClient = AccessController.doPrivileged(new PrivilegedExceptionAction<SaslClient>(){

                                        @Override
                                        public SaslClient run() throws SaslException {
                                            return factory.createSaslClient(strings, userName, protocol, remoteServerName, propertyMap, ClientConnectionOpenListener.this.callbackHandler);
                                        }
                                    }, ClientConnectionOpenListener.this.accessControlContext);
                                }
                                catch (PrivilegedActionException e) {
                                    ClientConnectionOpenListener.this.failedMechs.put(mechanism, e.getCause().toString());
                                }
                                if (saslClient == null) continue;
                                ClientConnectionOpenListener.this.failedMechs.remove(mechanism);
                                break block43;
                            }
                            ClientConnectionOpenListener.this.failedMechs.put(mechanism, "No implementation found");
                        }
                        if (saslClient == null) {
                            ClientConnectionOpenListener.this.connection.handleException(ClientConnectionOpenListener.this.allMechanismsFailed());
                            return;
                        }
                        final String mechanismName = saslClient.getMechanismName();
                        RemoteLogger.client.tracef("Client initiating authentication using mechanism %s", (Object)mechanismName);
                        String theRemoteEndpointName = remoteEndpointName;
                        ClientConnectionOpenListener.this.connection.getChannel().suspendReads();
                        final int negotiatedVersion = version;
                        final SaslClient usedSaslClient = saslClient;
                        final Authentication authentication = new Authentication(usedSaslClient, this.remoteServerName, userName, theRemoteEndpointName, behavior, channelsIn, channelsOut);
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                byte[] response;
                                try {
                                    response = usedSaslClient.hasInitialResponse() ? AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                                        @Override
                                        public byte[] run() throws Exception {
                                            return usedSaslClient.evaluateChallenge(SaslUtils.EMPTY_BYTES);
                                        }
                                    }, ClientConnectionOpenListener.this.accessControlContext) : null;
                                }
                                catch (PrivilegedActionException e) {
                                    RemoteLogger.client.tracef("Client authentication failed: %s", (Object)e.getCause());
                                    ClientConnectionOpenListener.this.saslDispose(usedSaslClient);
                                    ClientConnectionOpenListener.this.failedMechs.put(mechanismName, e.getCause().toString());
                                    ClientConnectionOpenListener.this.sendCapRequest(Capabilities.this.remoteServerName);
                                    return;
                                }
                                Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                                boolean ok = false;
                                try {
                                    ByteBuffer sendBuffer = pooledSendBuffer.getResource();
                                    sendBuffer.put((byte)2);
                                    if (negotiatedVersion < 1) {
                                        sendBuffer.put(mechanismName.getBytes(Protocol.UTF_8));
                                    } else {
                                        ProtocolUtils.writeString(sendBuffer, mechanismName);
                                        if (response != null) {
                                            sendBuffer.put(response);
                                        }
                                    }
                                    sendBuffer.flip();
                                    ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                    ok = true;
                                    ClientConnectionOpenListener.this.connection.setReadListener(authentication, true);
                                    return;
                                }
                                finally {
                                    if (!ok) {
                                        pooledSendBuffer.free();
                                    }
                                }
                            }
                        });
                        return;
                    }
                    default: {
                        RemoteLogger.client.unknownProtocolId(msgType);
                        ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                        return;
                    }
                }
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            if (ClientConnectionOpenListener.this.failedMechs.isEmpty()) {
                ClientConnectionOpenListener.this.connection.handleException(new SaslException("Authentication failed: the server presented no authentication mechanisms"));
                return;
            }
            ClientConnectionOpenListener.this.connection.handleException(ClientConnectionOpenListener.this.allMechanismsFailed());
            return;
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Greeting
    implements ChannelListener<ConnectedMessageChannel> {
        Greeting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", (Object)receiveBuffer);
                receiveBuffer.flip();
                String remoteServerName = null;
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 0: {
                        RemoteLogger.client.trace("Client received greeting");
                        block25: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice(receiveBuffer, len);
                            switch (type) {
                                case 0: {
                                    remoteServerName = Buffers.getModifiedUtf8(data);
                                    RemoteLogger.client.tracef("Client received server name: %s", (Object)remoteServerName);
                                    continue block25;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown greeting message %02x", (Object)(type & 0xFF));
                        }
                        if (remoteServerName == null) {
                            remoteServerName = channel.getPeerAddress(InetSocketAddress.class).getHostName();
                        }
                        ClientConnectionOpenListener.this.sendCapRequest(remoteServerName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }
}

