/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheAuthorizationManagerAction;
import org.infinispan.security.actions.GetCacheEntryAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.impl.SecureCacheImpl;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static AuthorizationManager getAuthorizationManager(AdvancedCache<?, ?> cache) {
        GetCacheAuthorizationManagerAction action = new GetCacheAuthorizationManagerAction(cache);
        return (AuthorizationManager)SecurityActions.doPrivileged(action);
    }

    static <K, V> Cache<K, V> getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        GetCacheAction action = new GetCacheAction(cacheManager, cacheName);
        return (Cache)SecurityActions.doPrivileged(action);
    }

    static <K, V> CacheEntry<K, V> getCacheEntry(AdvancedCache<K, V> cache, K key) {
        GetCacheEntryAction action = new GetCacheEntryAction(cache, key);
        return (CacheEntry)SecurityActions.doPrivileged(action);
    }

    static <K, V> Cache<K, V> getUnwrappedCache(Cache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return (Cache)SecurityActions.doPrivileged(() -> ((SecureCacheImpl)((SecureCacheImpl)cache)).getDelegate());
        }
        return cache;
    }
}

