/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.EnumSet;
import java.util.Map;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.PersistenceContextInitializerImpl;
import org.infinispan.scripting.impl.ScriptingInterceptor;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.CacheRoleImpl;
import org.infinispan.security.impl.CreatePermissionConfigurationBuilder;

@InfinispanModule(name="scripting", requiredModules={"core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration gc) {
        ScriptingManagerImpl scriptingManager = new ScriptingManagerImpl();
        gcr.registerComponent((Object)scriptingManager, ScriptingManager.class);
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)bcr.getComponent(InternalCacheRegistry.class).wired();
        internalCacheRegistry.registerInternalCache("___script_cache", this.getScriptCacheConfiguration(gc).build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED, InternalCacheRegistry.Flag.PERSISTENT, InternalCacheRegistry.Flag.GLOBAL));
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        ScriptingManagerImpl scriptingManager = (ScriptingManagerImpl)gcr.getComponent(ScriptingManager.class);
        scriptingManager.getScriptCache();
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        if ("___script_cache".equals(cacheName)) {
            BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
            ScriptingInterceptor scriptingInterceptor = new ScriptingInterceptor();
            bcr.registerComponent(ScriptingInterceptor.class, (Object)scriptingInterceptor, true);
            bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), ScriptingInterceptor.class.getName());
            ((AsyncInterceptorChain)bcr.getComponent(AsyncInterceptorChain.class).wired()).addInterceptorAfter((AsyncInterceptor)scriptingInterceptor, CacheMgmtInterceptor.class);
        }
    }

    private ConfigurationBuilder getScriptCacheConfiguration(GlobalConfiguration globalConfiguration) {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.encoding().key().mediaType("application/x-java-object");
        cfg.encoding().value().mediaType("application/x-java-object");
        if (globalConfiguration.security().authorization().enabled()) {
            Map globalRoles = globalConfiguration.security().authorization().roles();
            globalRoles.put("___script_manager", new CacheRoleImpl("___script_manager", false, new AuthorizationPermission[]{AuthorizationPermission.ALL}));
            AuthorizationConfigurationBuilder authorization = cfg.security().authorization().enable();
            globalRoles.keySet().forEach(role -> authorization.role(role));
            cfg.addModule(CreatePermissionConfigurationBuilder.class);
        }
        return cfg;
    }
}

