package org.infinispan.scripting.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-03-10T11:56:43-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String scriptExecutionError$str() {
        return "ISPN027503: Script execution error";
    }
    @Override
    public final CacheException scriptExecutionError(final Throwable t) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), scriptExecutionError$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String scriptCompilationException$str() {
        return "ISPN027504: Compiler error for script '%s'";
    }
    @Override
    public final CacheException scriptCompilationException(final Throwable t, final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), scriptCompilationException$str(), name), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noNamedScript$str() {
        return "ISPN027505: No script named '%s'";
    }
    @Override
    public final CacheException noNamedScript(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noNamedScript$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownScriptProperty$str() {
        return "ISPN027506: Unknown script mode: '%s'";
    }
    @Override
    public final CacheException unknownScriptProperty(final String value) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unknownScriptProperty$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noScriptEngineForScript$str() {
        return "ISPN027507: Cannot find an appropriate script engine for '%s'";
    }
    @Override
    public final IllegalArgumentException noScriptEngineForScript(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noScriptEngineForScript$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInvokeScriptDirectly$str() {
        return "ISPN027508: Script '%s' cannot be invoked directly since it specifies mode '%s'";
    }
    @Override
    public final IllegalArgumentException cannotInvokeScriptDirectly(final String scriptName, final String property) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInvokeScriptDirectly$str(), scriptName, property));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String distributedTaskNeedCacheInBinding$str() {
        return "ISPN027509: Distributed script '%s' invoked without a cache binding";
    }
    @Override
    public final IllegalStateException distributedTaskNeedCacheInBinding(final String scriptName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), distributedTaskNeedCacheInBinding$str(), scriptName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noEngineForScript$str() {
        return "ISPN027510: Cannot find an appropriate script engine for script '%s'";
    }
    @Override
    public final IllegalArgumentException noEngineForScript(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noEngineForScript$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parametersNotArray$str() {
        return "ISPN027511: Script parameters must be declared using the array notation, e.g. [a,b,c]";
    }
    @Override
    public final IllegalArgumentException parametersNotArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parametersNotArray$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scriptsCanOnlyAccessNamedCaches$str() {
        return "ISPN027512: Scripts can only access named caches";
    }
    @Override
    public final IllegalArgumentException scriptsCanOnlyAccessNamedCaches() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), scriptsCanOnlyAccessNamedCaches$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
