/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InjectiveFunction;
import org.infinispan.scripting.impl.DataType;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.util.CacheCollectionMapper;
import org.infinispan.util.CacheSetMapper;

public final class DataTypedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    final DataTypedCacheManager dataTypedCacheManager;
    private final Function<V, V> toDataType = this::toDataType;

    public DataTypedCache(DataTypedCacheManager dataTypedCacheManager, Cache<K, V> cache) {
        super(cache.getAdvancedCache());
        this.dataTypedCacheManager = dataTypedCacheManager;
    }

    private <T> T fromDataType(Object obj) {
        return (T)this.dataTypedCacheManager.dataType.transformer.fromDataType(obj, this.dataTypedCacheManager.marshaller);
    }

    private <T> T toDataType(Object obj) {
        return (T)this.dataTypedCacheManager.dataType.transformer.toDataType(obj, this.dataTypedCacheManager.marshaller);
    }

    public void putForExternalRead(K key, V value) {
        this.getDelegate().putForExternalRead(this.fromDataType(key), this.fromDataType(value));
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.getDelegate().putForExternalRead(this.fromDataType(key), this.fromDataType(value), lifespan, unit);
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.getDelegate().putForExternalRead(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public void evict(K key) {
        this.getDelegate().evict(this.fromDataType(key));
    }

    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(this.fromDataType(key));
    }

    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(this.fromDataType(value));
    }

    public V get(Object key) {
        return (V)this.toDataType(this.getDelegate().get(this.fromDataType(key)));
    }

    public CacheSet<K> keySet() {
        return new CacheSetMapper(this.getDelegate().keySet(), new ValueToTypedValueFunction(this.dataTypedCacheManager.dataType, this.dataTypedCacheManager.marshaller));
    }

    public CacheCollection<V> values() {
        return new CacheCollectionMapper(this.getDelegate().values(), new ValueToTypedValueFunction(this.dataTypedCacheManager.dataType, this.dataTypedCacheManager.marshaller));
    }

    public CacheSet<Map.Entry<K, V>> entrySet() {
        return new CacheSetMapper(this.getDelegate().entrySet(), new EntryToTypedEntryFunction(this.dataTypedCacheManager.dataType, this.dataTypedCacheManager.marshaller));
    }

    public V put(K key, V value) {
        return (V)this.toDataType(this.getDelegate().put(this.fromDataType(key), this.fromDataType(value)));
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.toDataType(this.getDelegate().put(this.fromDataType(key), this.fromDataType(value), lifespan, unit));
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.toDataType(this.getDelegate().putIfAbsent(this.fromDataType(key), this.fromDataType(value), lifespan, unit));
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        Map<? extends K, ? extends V> map2 = this.fromDataTypeMap(map);
        this.getDelegate().putAll(map2, lifespan, unit);
    }

    public Map<K, V> fromDataTypeMap(Map<? extends K, ? extends V> map) {
        Stream<Map.Entry> stream = map.entrySet().stream().map(e -> Immutables.immutableEntry(this.fromDataType(e.getKey()), this.fromDataType(e.getValue())));
        return stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.toDataType(this.getDelegate().replace(this.fromDataType(key), this.fromDataType(value), lifespan, unit));
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.getDelegate().replace(this.fromDataType(key), this.fromDataType(oldValue), this.fromDataType(value), lifespan, unit);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.toDataType(this.getDelegate().put(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.toDataType(this.getDelegate().putIfAbsent(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Map<? extends K, ? extends V> map2 = this.fromDataTypeMap(map);
        this.getDelegate().putAll(map2, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.toDataType(this.getDelegate().replace(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.getDelegate().replace(this.fromDataType(key), this.fromDataType(oldValue), this.fromDataType(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V remove(Object key) {
        return (V)this.toDataType(this.getDelegate().remove(this.fromDataType(key)));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        Map<? extends K, ? extends V> map2 = this.fromDataTypeMap(m);
        this.getDelegate().putAll(map2);
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        return this.getDelegate().putAsync(this.fromDataType(key), this.fromDataType(value)).thenApply(this.toDataType);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.getDelegate().putAsync(this.fromDataType(key), this.fromDataType(value), lifespan, unit).thenApply(this.toDataType);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.getDelegate().putAsync(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.toDataType);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        Map<? extends K, ? extends V> map2 = this.fromDataTypeMap(data);
        return this.getDelegate().putAllAsync(map2);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        Map<? extends K, ? extends V> map2 = this.fromDataTypeMap(data);
        return this.getDelegate().putAllAsync(map2, lifespan, unit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Map<? extends K, ? extends V> map2 = this.fromDataTypeMap(data);
        return this.getDelegate().putAllAsync(map2, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.getDelegate().putIfAbsentAsync(this.fromDataType(key), this.fromDataType(value)).thenApply(this.toDataType);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.getDelegate().putIfAbsentAsync(this.fromDataType(key), this.fromDataType(value), lifespan, unit).thenApply(this.toDataType);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.getDelegate().putIfAbsentAsync(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.toDataType);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return this.getDelegate().removeAsync(this.fromDataType(key)).thenApply(this.toDataType);
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.getDelegate().removeAsync(this.fromDataType(key), this.fromDataType(value));
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.getDelegate().replaceAsync(this.fromDataType(key), this.fromDataType(value)).thenApply(this.toDataType);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.getDelegate().replaceAsync(this.fromDataType(key), this.fromDataType(value), lifespan, unit).thenApply(this.toDataType);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.getDelegate().replaceAsync(this.fromDataType(key), this.fromDataType(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.toDataType);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.getDelegate().replaceAsync(this.fromDataType(key), this.fromDataType(oldValue), this.fromDataType(newValue));
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.getDelegate().replaceAsync(this.fromDataType(key), this.fromDataType(oldValue), this.fromDataType(newValue), lifespan, unit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.getDelegate().replaceAsync(this.fromDataType(key), this.fromDataType(oldValue), this.fromDataType(newValue), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> getAsync(K key) {
        return this.getDelegate().getAsync(this.fromDataType(key)).thenApply(this.toDataType);
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.toDataType(this.getDelegate().putIfAbsent(this.fromDataType(key), this.fromDataType(value)));
    }

    public boolean remove(Object key, Object value) {
        return this.getDelegate().remove(this.fromDataType(key), this.fromDataType(value));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.getDelegate().replace(this.fromDataType(key), this.fromDataType(oldValue), this.fromDataType(newValue));
    }

    public V replace(K key, V value) {
        return (V)this.getDelegate().replace(this.fromDataType(key), this.fromDataType(value));
    }

    @SerializeWith(value=Externalizer.class)
    public static final class EntryToTypedEntryFunction<K, V>
    implements Function<Map.Entry<K, V>, Map.Entry<K, V>>,
    InjectiveFunction<Map.Entry<K, V>, Map.Entry<K, V>> {
        private final DataType dataType;
        private final Optional<Marshaller> marshaller;

        public EntryToTypedEntryFunction(DataType dataType, Optional<Marshaller> marshaller) {
            this.dataType = dataType;
            this.marshaller = marshaller;
        }

        @Override
        public Map.Entry<K, V> apply(Map.Entry<K, V> e) {
            return Immutables.immutableEntry((Object)this.dataType.transformer.toDataType(e.getKey(), this.marshaller), (Object)this.dataType.transformer.toDataType(e.getValue(), this.marshaller));
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<EntryToTypedEntryFunction> {
            public void writeObject(ObjectOutput output, EntryToTypedEntryFunction object) throws IOException {
                output.writeInt(object.dataType.ordinal());
            }

            public EntryToTypedEntryFunction readObject(ObjectInput input) throws IOException {
                int ordinal = input.readInt();
                return new EntryToTypedEntryFunction(DataType.values()[ordinal], Optional.empty());
            }
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static final class ValueToTypedValueFunction<T>
    implements Function<T, T>,
    InjectiveFunction<T, T> {
        private final DataType dataType;
        private final Optional<Marshaller> marshaller;

        public ValueToTypedValueFunction(DataType dataType, Optional<Marshaller> marshaller) {
            this.dataType = dataType;
            this.marshaller = marshaller;
        }

        @Override
        public Object apply(Object o) {
            return this.dataType.transformer.toDataType(o, this.marshaller);
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ValueToTypedValueFunction> {
            public void writeObject(ObjectOutput output, ValueToTypedValueFunction object) throws IOException {
                output.writeInt(object.dataType.ordinal());
            }

            public ValueToTypedValueFunction readObject(ObjectInput input) throws IOException {
                int ordinal = input.readInt();
                return new ValueToTypedValueFunction(DataType.values()[ordinal], Optional.empty());
            }
        }
    }
}

