/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.encoding.DataConversion;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.tasks.TaskContext;

public final class ScriptConversions {
    public static final MediaType APPLICATION_TEXT_STRING = MediaType.TEXT_PLAIN.withClassType(String.class);
    private final Map<String, OutputFormatter> formatterByMediaType = new HashMap<String, OutputFormatter>(2);
    private final EncoderRegistry encoderRegistry;

    public ScriptConversions(EncoderRegistry encoderRegistry) {
        this.encoderRegistry = encoderRegistry;
        this.formatterByMediaType.put("text/plain", new TextPlainFormatter());
    }

    public Map<String, ?> convertParameters(TaskContext context) {
        if (!context.getParameters().isPresent()) {
            return null;
        }
        Map contextParams = (Map)context.getParameters().get();
        HashMap converted = new HashMap(contextParams.size());
        if (context.getCache().isPresent()) {
            DataConversion valueDataConversion = ((Cache)context.getCache().get()).getAdvancedCache().getValueDataConversion();
            MediaType requestMediaType = valueDataConversion.getRequestMediaType();
            contextParams.forEach((s, o) -> {
                Object c = requestMediaType == null ? o : valueDataConversion.convert(o, valueDataConversion.getRequestMediaType(), MediaType.APPLICATION_OBJECT);
                converted.put(s, c);
            });
            return converted;
        }
        return contextParams;
    }

    public Object convertToRequestType(Object obj, MediaType objType, MediaType requestType) {
        if (obj == null) {
            return null;
        }
        if (requestType.equals((Object)MediaType.MATCH_ALL)) {
            return obj;
        }
        MediaType outputFormat = requestType.match(MediaType.APPLICATION_UNKNOWN) ? objType : requestType;
        OutputFormatter outputFormatter = this.formatterByMediaType.get(outputFormat.getTypeSubtype());
        if (obj instanceof Collection && outputFormatter != null) {
            return outputFormatter.formatCollection((Collection)obj, objType, requestType);
        }
        Transcoder transcoder = this.encoderRegistry.getTranscoder(objType, requestType);
        return transcoder.transcode(obj, objType, requestType);
    }

    private class TextPlainFormatter
    implements OutputFormatter {
        private TextPlainFormatter() {
        }

        private String quote(Object element) {
            if (element == null) {
                return "null";
            }
            return "\"" + element.toString() + "\"";
        }

        @Override
        public Object formatCollection(Collection<?> elements, MediaType elementType, MediaType destinationType) {
            Transcoder transcoder = ScriptConversions.this.encoderRegistry.getTranscoder(elementType, APPLICATION_TEXT_STRING);
            return elements.stream().map(s -> transcoder.transcode(s, elementType, APPLICATION_TEXT_STRING)).map(this::quote).collect(Collectors.joining(", ", "[", "]")).getBytes(destinationType.getCharset());
        }
    }

    private static interface OutputFormatter {
        public Object formatCollection(Collection<?> var1, MediaType var2, MediaType var3);
    }
}

