/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.listener;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.ByRef;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.counter.listener.ClientNotificationManager;
import org.infinispan.server.hotrod.counter.listener.ListenerOperationStatus;

public class ClientCounterManagerNotificationManager {
    private final CounterManager counterManager;
    private final Map<WrappedByteArray, ClientNotificationManager> clientManagers;

    public ClientCounterManagerNotificationManager(CounterManager counterManager) {
        this.counterManager = counterManager;
        this.clientManagers = new ConcurrentHashMap<WrappedByteArray, ClientNotificationManager>();
    }

    private static WrappedByteArray wrapId(byte[] id) {
        return new WrappedByteArray(id);
    }

    public void stop() {
        this.clientManagers.values().forEach(ClientNotificationManager::removeAll);
        this.clientManagers.clear();
    }

    public ListenerOperationStatus addCounterListener(byte[] listenerId, byte version, String counterName, Channel channel, VersionedEncoder encoder) {
        ByRef status = new ByRef((Object)ListenerOperationStatus.COUNTER_NOT_FOUND);
        this.clientManagers.compute(ClientCounterManagerNotificationManager.wrapId(listenerId), (id, manager) -> this.add((WrappedByteArray)id, (ClientNotificationManager)manager, version, counterName, channel, encoder, (ByRef<ListenerOperationStatus>)status));
        return (ListenerOperationStatus)((Object)status.get());
    }

    public ListenerOperationStatus removeCounterListener(byte[] listenerId, String counterName) {
        ByRef status = new ByRef((Object)ListenerOperationStatus.COUNTER_NOT_FOUND);
        this.clientManagers.computeIfPresent(ClientCounterManagerNotificationManager.wrapId(listenerId), (id, manager) -> this.rm((ClientNotificationManager)manager, counterName, (ByRef<ListenerOperationStatus>)status));
        return (ListenerOperationStatus)((Object)status.get());
    }

    public void channelActive(Channel channel) {
        channel.eventLoop().execute(() -> this.clientManagers.values().forEach(manager -> manager.channelActive(channel)));
    }

    private ClientNotificationManager add(WrappedByteArray id, ClientNotificationManager manager, byte version, String counterName, Channel channel, VersionedEncoder encoder, ByRef<ListenerOperationStatus> status) {
        boolean useChannel = false;
        if (manager == null) {
            manager = new ClientNotificationManager(id.getBytes(), this.counterManager, channel, encoder);
            useChannel = true;
        }
        if (manager.addCounterListener(version, counterName)) {
            status.set((Object)(useChannel ? ListenerOperationStatus.OK_AND_CHANNEL_IN_USE : ListenerOperationStatus.OK));
            return manager;
        }
        status.set((Object)ListenerOperationStatus.COUNTER_NOT_FOUND);
        return null;
    }

    private ClientNotificationManager rm(ClientNotificationManager manager, String counterName, ByRef<ListenerOperationStatus> status) {
        if (counterName.isEmpty()) {
            manager.removeAll();
        } else {
            manager.removeCounterListener(counterName);
        }
        if (manager.isEmpty()) {
            status.set((Object)ListenerOperationStatus.OK_AND_CHANNEL_IN_USE);
            return null;
        }
        status.set((Object)ListenerOperationStatus.OK);
        return manager;
    }
}

