/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.ServerAddress;

public class MultiHomedServerAddress
implements ServerAddress {
    private final int port;
    private final List<InetAddressWithNetMask> addresses;
    static byte[] netMaskByPrefix = new byte[]{-128, -64, -32, -16, -8, -4, -2};

    public MultiHomedServerAddress(int port, boolean networkPrefixOverride) {
        this.port = port;
        this.addresses = new ArrayList<InetAddressWithNetMask>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                for (InterfaceAddress address : intf.getInterfaceAddresses()) {
                    this.addresses.add(new InetAddressWithNetMask(address.getAddress(), address.getNetworkPrefixLength(), networkPrefixOverride));
                }
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private MultiHomedServerAddress(List<InetAddressWithNetMask> addresses, int port) {
        this.addresses = addresses;
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiHomedServerAddress that = (MultiHomedServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.addresses.equals(that.addresses);
    }

    public int hashCode() {
        int result = this.addresses.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "MultiHomedServerAddress{port=" + this.port + ", addresses=" + this.addresses + "}";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost(InetAddress localAddress) {
        for (InetAddressWithNetMask address : this.addresses) {
            if (!MultiHomedServerAddress.inetAddressMatchesInterfaceAddress(localAddress.getAddress(), address.address.getAddress(), address.prefixLength)) continue;
            if (HotRodServer.log.isDebugEnabled()) {
                HotRodServer.log.debugf("Matched incoming address '%s' with '%s'", localAddress, address);
            }
            return address.address.getHostAddress();
        }
        throw new IllegalArgumentException("No interface address matching '" + localAddress + "' in " + this);
    }

    public static boolean inetAddressMatchesInterfaceAddress(byte[] inetAddress, byte[] interfaceAddress, int prefixLength) {
        if (HotRodServer.log.isDebugEnabled()) {
            HotRodServer.log.debugf("Matching incoming address '%s' with '%s'/%d", inetAddress, interfaceAddress, prefixLength);
        }
        if (inetAddress.length != interfaceAddress.length) {
            return false;
        }
        for (int i = 0; i < inetAddress.length; ++i) {
            byte a = inetAddress[i];
            byte b = interfaceAddress[i];
            if (prefixLength >= 8) {
                if (a != b) {
                    return false;
                }
                prefixLength -= 8;
                continue;
            }
            if (prefixLength <= 0) continue;
            byte mask = netMaskByPrefix[prefixLength - 1];
            if ((a & mask) != (b & mask)) {
                return false;
            }
            prefixLength = 0;
        }
        return true;
    }

    public static class InetAddressWithNetMask {
        public static final InetAddressWithNetMask RFC1918_CIDR_10 = new InetAddressWithNetMask(new byte[]{10, 0, 0, 0}, 8);
        public static final InetAddressWithNetMask RFC1918_CIDR_172 = new InetAddressWithNetMask(new byte[]{-84, 16, 0, 0}, 12);
        public static final InetAddressWithNetMask RFC1918_CIDR_192 = new InetAddressWithNetMask(new byte[]{-64, -88, 0, 0}, 16);
        public static final InetAddressWithNetMask RFC3927_LINK_LOCAL = new InetAddressWithNetMask(new byte[]{-87, -2, 0, 0}, 16);
        public static final InetAddressWithNetMask RFC1112_RESERVED = new InetAddressWithNetMask(new byte[]{-16, 0, 0, 0}, 4);
        public static final InetAddressWithNetMask RFC6598_SHARED_SPACE = new InetAddressWithNetMask(new byte[]{100, 64, 0, 0}, 10);
        public static final InetAddressWithNetMask RFC4193_ULA = new InetAddressWithNetMask(new byte[]{-4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7);
        public static final InetAddressWithNetMask RFC4193_LINK_LOCAL = new InetAddressWithNetMask(new byte[]{-2, -128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10);
        public static final List<InetAddressWithNetMask> PRIVATE_NETWORKS = Arrays.asList(RFC1918_CIDR_10, RFC1918_CIDR_172, RFC1918_CIDR_192, RFC3927_LINK_LOCAL, RFC1112_RESERVED, RFC6598_SHARED_SPACE, RFC4193_ULA, RFC4193_LINK_LOCAL);
        final InetAddress address;
        final short prefixLength;

        public InetAddressWithNetMask(InetAddress address, short prefixLength, boolean networkPrefixOverride) {
            this.address = address;
            short prefix = prefixLength;
            if (networkPrefixOverride) {
                byte[] a = address.getAddress();
                for (InetAddressWithNetMask net : PRIVATE_NETWORKS) {
                    if (!MultiHomedServerAddress.inetAddressMatchesInterfaceAddress(a, net.address.getAddress(), net.prefixLength)) continue;
                    prefix = net.prefixLength;
                    break;
                }
            }
            this.prefixLength = prefix;
        }

        private InetAddressWithNetMask(byte[] address, short prefixLength) {
            try {
                this.address = InetAddress.getByAddress(address);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            this.prefixLength = prefixLength;
        }

        public InetAddressWithNetMask(InetAddress address, short prefixLength) {
            this.address = address;
            this.prefixLength = prefixLength;
        }

        public String toString() {
            return this.address + "/" + this.prefixLength;
        }
    }

    static class Externalizer
    extends AbstractExternalizer<MultiHomedServerAddress> {
        Externalizer() {
        }

        public Set<Class<? extends MultiHomedServerAddress>> getTypeClasses() {
            return Collections.singleton(MultiHomedServerAddress.class);
        }

        public void writeObject(ObjectOutput output, MultiHomedServerAddress object) throws IOException {
            output.writeInt(object.addresses.size());
            for (InetAddressWithNetMask address : object.addresses) {
                output.writeObject(address.address.getHostAddress());
                output.writeShort(address.prefixLength);
            }
            output.writeShort(object.port);
        }

        public MultiHomedServerAddress readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            ArrayList<InetAddressWithNetMask> addresses = new ArrayList<InetAddressWithNetMask>(size);
            for (int i = 0; i < size; ++i) {
                String address = (String)input.readObject();
                short prefixLength = input.readShort();
                addresses.add(new InetAddressWithNetMask(InetAddress.getByName(address), prefixLength));
            }
            int port = input.readUnsignedShort();
            return new MultiHomedServerAddress(addresses, port);
        }
    }
}

