/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.operation;

import jakarta.transaction.HeuristicCommitException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.command.tx.ForwardRollbackCommand;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.operation.BaseCompleteTransactionOperation;
import org.infinispan.server.hotrod.tx.operation.Util;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

public class RollbackTransactionOperation
extends BaseCompleteTransactionOperation {
    private static final Log log = (Log)LogFactory.getLog(RollbackTransactionOperation.class, Log.class);
    private final BiFunction<?, Throwable, Void> handler = (ignored, throwable) -> {
        if (throwable != null) {
            while (throwable != null) {
                if (throwable instanceof HeuristicRollbackException || throwable instanceof RollbackException) {
                    this.hasRollbacks = true;
                    return null;
                }
                if (throwable instanceof HeuristicCommitException) {
                    this.hasCommits = true;
                } else if (throwable instanceof HeuristicMixedException) {
                    this.hasCommits = true;
                    this.hasRollbacks = true;
                    return null;
                }
                throwable = throwable.getCause();
            }
            this.hasErrors = true;
        } else {
            this.hasRollbacks = true;
        }
        return null;
    };

    public RollbackTransactionOperation(HotRodHeader header, HotRodServer server, Subject subject, XidImpl xid, BiConsumer<HotRodHeader, Integer> reply) {
        super(header, server, subject, xid, reply);
    }

    @Override
    public void run() {
        this.globalTxTable.markToRollback(this.xid, this);
    }

    @Override
    public void addCache(ByteString cacheName, Status status) {
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Collected cache %s status %s", this.xid, cacheName, (Object)status);
        }
        switch (status) {
            case ROLLED_BACK: {
                break;
            }
            case MARK_COMMIT: 
            case COMMITTED: {
                this.hasCommits = true;
                break;
            }
            case ERROR: {
                this.hasErrors = true;
                break;
            }
            case PREPARED: 
            case ACTIVE: 
            case PREPARING: 
            case NO_TRANSACTION: {
                this.hasErrors = true;
                break;
            }
            default: {
                this.cacheNames.add(cacheName);
            }
        }
        this.notifyCacheCollected();
    }

    @Override
    <T> BiFunction<T, Throwable, Void> handler() {
        return this.handler;
    }

    @Override
    void sendReply() {
        int xaCode = 0;
        if (this.hasErrors) {
            xaCode = -3;
        } else if (this.hasRollbacks && this.hasCommits) {
            xaCode = 5;
        } else if (this.hasCommits) {
            xaCode = 7;
        }
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Sending reply %s", this.xid, xaCode);
        }
        this.reply.accept(this.header, xaCode);
    }

    @Override
    CacheRpcCommand buildRemoteCommand(Configuration configuration, CommandsFactory commandsFactory, TxState state) {
        return commandsFactory.buildRollbackCommand(state.getGlobalTransaction());
    }

    @Override
    CacheRpcCommand buildForwardCommand(ByteString cacheName, long timeout) {
        return new ForwardRollbackCommand(cacheName, this.xid, timeout);
    }

    @Override
    CompletionStage<Void> asyncCompleteLocalTransaction(AdvancedCache<?, ?> cache, long timeout) {
        return this.blockingManager.runBlocking(() -> {
            try {
                Util.rollbackLocalTransaction(cache, this.xid, timeout);
            }
            catch (HeuristicMixedException e) {
                this.hasCommits = true;
                this.hasRollbacks = true;
            }
            catch (Throwable t) {
                this.hasErrors = true;
            }
        }, (Object)this);
    }
}

