package org.infinispan.server.hotrod.logging;

import java.util.Locale;
import org.infinispan.distribution.ch.ConsistentHash;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.util.Set;
import org.infinispan.commons.dataconversion.EncodingException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.counter.exception.CounterException;
import java.lang.Object;
import java.util.Arrays;
import java.net.SocketAddress;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-01-19T03:21:16-0500")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void exceptionReported(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, exceptionReported$str());
    }
    protected String exceptionReported$str() {
        return "ISPN005003: Exception reported";
    }
    @Override
    public final void noMembersInHashTopology(final ConsistentHash ch, final String topologyMap) {
        super.log.logf(FQCN, WARN, null, noMembersInHashTopology$str(), ch, topologyMap);
    }
    protected String noMembersInHashTopology$str() {
        return "ISPN005019: No members for new topology after applying consistent hash %s filtering into base topology %s";
    }
    @Override
    public final void noMembersInTopology() {
        super.log.logf(FQCN, WARN, null, noMembersInTopology$str());
    }
    protected String noMembersInTopology$str() {
        return "ISPN005020: No members in new topology";
    }
    @Override
    public final void errorDetectingCrashedMember(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorDetectingCrashedMember$str());
    }
    protected String errorDetectingCrashedMember$str() {
        return "ISPN006002: Error detecting crashed member";
    }
    protected String serverAuthenticationProvider$str() {
        return "ISPN006005: Cannot enable authentication without specifying a ServerAuthenticationProvider";
    }
    @Override
    public final CacheConfigurationException serverAuthenticationProvider() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), serverAuthenticationProvider$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidAllowedMechs$str() {
        return "ISPN006006: The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]";
    }
    @Override
    public final CacheConfigurationException invalidAllowedMechs(final Set<String> allowedMechs, final Set<String> allMechs) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidAllowedMechs$str(), allowedMechs, allMechs));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidOperation$str() {
        return "ISPN006007: The requested operation is invalid";
    }
    @Override
    public final UnsupportedOperationException invalidOperation() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), invalidOperation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingServerName$str() {
        return "ISPN006008: A serverName must be specified when enabling authentication";
    }
    @Override
    public final CacheConfigurationException missingServerName() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingServerName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedEvent$str() {
        return "ISPN006009: Event not handled by current Hot Rod event implementation: '%s'";
    }
    @Override
    public final IllegalStateException unexpectedEvent(final Event e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedEvent$str(), e));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnConditionalOperationNonTransactional(final String op) {
        if (super.log.isEnabled(WARN) && warnConditionalOperationNonTransactional_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, warnConditionalOperationNonTransactional$str(), op);
        }
    }
    protected String warnConditionalOperationNonTransactional$str() {
        return "ISPN006010: Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations";
    }
    private static final AtomicBoolean warnConditionalOperationNonTransactional_$Once = new AtomicBoolean(false);
    @Override
    public final void warnForceReturnPreviousNonTransactional(final String op) {
        if (super.log.isEnabled(WARN) && warnForceReturnPreviousNonTransactional_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, warnForceReturnPreviousNonTransactional$str(), op);
        }
    }
    protected String warnForceReturnPreviousNonTransactional$str() {
        return "ISPN006011: Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations";
    }
    private static final AtomicBoolean warnForceReturnPreviousNonTransactional_$Once = new AtomicBoolean(false);
    protected String missingCacheEventFactory$str() {
        return "ISPN006013: Listener %s factory '%s' not found in server";
    }
    @Override
    public final MissingFactoryException missingCacheEventFactory(final String factoryType, final String name) {
        final MissingFactoryException result = new MissingFactoryException(String.format(getLoggingLocale(), missingCacheEventFactory$str(), factoryType, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalFilterConverterEventFactory$str() {
        return "ISPN006014: Trying to add a filter and converter factory with name '%s' but it does not extend CacheEventFilterConverterFactory";
    }
    @Override
    public final IllegalStateException illegalFilterConverterEventFactory(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalFilterConverterEventFactory$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingKeyValueFilterConverterFactory$str() {
        return "ISPN006016: Factory '%s' not found in server";
    }
    @Override
    public final IllegalStateException missingKeyValueFilterConverterFactory(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingKeyValueFilterConverterFactory$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unauthorizedOperation$str() {
        return "ISPN006017: Operation '%s' requires authentication";
    }
    @Override
    public final SecurityException unauthorizedOperation(final String op) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unauthorizedOperation$str(), op));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String externalMechNotAllowedWithoutSSLClientCert$str() {
        return "ISPN006018: EXTERNAL SASL mechanism not allowed without SSL client certificate";
    }
    @Override
    public final SecurityException externalMechNotAllowedWithoutSSLClientCert() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), externalMechNotAllowedWithoutSSLClientCert$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingHostAddress$str() {
        return "ISPN006019: A host or proxyHost address has not been specified";
    }
    @Override
    public final CacheConfigurationException missingHostAddress() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingHostAddress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedTransactionalCache$str() {
        return "ISPN006020: Cache '%s' is not transactional to execute a client transaction";
    }
    @Override
    public final IllegalStateException expectedTransactionalCache(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), expectedTransactionalCache$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedIsolationLevel$str() {
        return "ISPN006021: Cache '%s' must have REPEATABLE_READ isolation level";
    }
    @Override
    public final IllegalStateException unexpectedIsolationLevel(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedIsolationLevel$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidWeakCounter$str() {
        return "ISPN028023: Expects a STRONG counter for '%s'";
    }
    @Override
    public final CounterException invalidWeakCounter(final String name) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidWeakCounter$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void skippingMarshallerWrapping(final String mediaType) {
        if (super.log.isEnabled(WARN) && skippingMarshallerWrapping_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, skippingMarshallerWrapping$str(), mediaType);
        }
    }
    protected String skippingMarshallerWrapping$str() {
        return "ISPN028024: Not wrapping custom marshaller with media type '%s' since the format is already supported by the server";
    }
    private static final AtomicBoolean skippingMarshallerWrapping_$Once = new AtomicBoolean(false);
    protected String errorSerializingResponse$str() {
        return "ISPN028025: Error serializing script response '%s'";
    }
    @Override
    public final EncodingException errorSerializingResponse(final Object o) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorSerializingResponse$str(), o));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void removedUnclosedIterator(final String iteratorId) {
        super.log.logf(FQCN, WARN, null, removedUnclosedIterator$str(), iteratorId);
    }
    protected String removedUnclosedIterator$str() {
        return "ISPN028026: Removed unclosed iterator '%s'";
    }
    protected String authenticationException$str() {
        return "ISPN028027: Invalid credentials";
    }
    @Override
    public final SecurityException authenticationException(final Throwable cause) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationException$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMech$str() {
        return "ISPN028028: Invalid mech '%s'";
    }
    @Override
    public final IllegalArgumentException invalidMech(final String mech) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMech$str(), mech));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void clientNotUpdatingTopology(final SocketAddress socketAddress, final int topologyId) {
        super.log.logf(FQCN, WARN, null, clientNotUpdatingTopology$str(), socketAddress, topologyId);
    }
    protected String clientNotUpdatingTopology$str() {
        return "ISPN028029: Client %s keeps providing outdated topology %s";
    }
}
