/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSharedContainerTest")
public class HotRodSharedContainerTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodClient hotRodClient1;
    private HotRodClient hotRodClient2;
    private String cacheName = "HotRodCache";

    protected void createCacheManagers() {
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg, (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManagers.add(cm);
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration(HotRodSharedContainerTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        cm.defineConfiguration(this.cacheName, builder.build());
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testTopologyConflict() {
        int basePort = HotRodTestingUtil.serverPort();
        this.hotRodServer1 = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0), basePort, new HotRodServerConfigurationBuilder());
        this.hotRodServer2 = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0), basePort + 50, new HotRodServerConfigurationBuilder());
    }

    public void testSharedContainer(Method m) {
        int basePort = HotRodTestingUtil.serverPort();
        this.hotRodServer1 = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0), basePort, (HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().name("1"));
        this.hotRodServer2 = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0), basePort + 50, (HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().name("2"));
        this.hotRodClient1 = new HotRodClient("127.0.0.1", this.hotRodServer1.getPort(), this.cacheName, 60, 20);
        this.hotRodClient2 = new HotRodClient("127.0.0.1", this.hotRodServer2.getPort(), this.cacheName, 60, 20);
        this.hotRodClient1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertSuccess(this.hotRodClient2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
    }

    @AfterMethod(alwaysRun=true)
    void killClientsAndServers() {
        HotRodTestingUtil.killClient(this.hotRodClient1);
        HotRodTestingUtil.killClient(this.hotRodClient2);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer1);
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer2);
    }
}

