/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.SkipIndexingFlagCheckCommandInterceptor;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.SkipIndexingHotRodTest")
public class SkipIndexingHotRodTest
extends HotRodSingleNodeTest {
    private static final int SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE = SkipIndexingHotRodTest.join(ProtocolFlag.SkipIndexing.getValue(), ProtocolFlag.ForceReturnPreviousValue.getValue());

    public void testPut(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0), OperationStatus.Success);
        commandInterceptor.expectSkipIndexingFlag = true;
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.Success);
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.SuccessWithPrevious);
    }

    public void testReplace(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0), OperationStatus.OperationNotExecuted);
        commandInterceptor.expectSkipIndexingFlag = true;
        HotRodTestingUtil.assertStatus(this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.OperationNotExecuted);
        HotRodTestingUtil.assertStatus(this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.OperationNotExecuted);
    }

    public void testPutIfAbsent(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0), OperationStatus.Success);
        commandInterceptor.expectSkipIndexingFlag = true;
        HotRodTestingUtil.assertStatus(this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.OperationNotExecuted);
        HotRodTestingUtil.assertStatus(this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.NotExecutedWithPrevious);
    }

    public void testReplaceIfUnmodified(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = true;
        HotRodTestingUtil.assertStatus(this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testGet(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().get(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().get(HotRodTestingUtil.k(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().get(HotRodTestingUtil.k(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testGetWithVersion(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().getWithVersion(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().getWithVersion(HotRodTestingUtil.k(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().getWithVersion(HotRodTestingUtil.k(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testGetWithMetadata(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().getWithMetadata(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().getWithMetadata(HotRodTestingUtil.k(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().getWithMetadata(HotRodTestingUtil.k(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testRemove(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = true;
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testRemoveIfUnmodified(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0L, 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = true;
        HotRodTestingUtil.assertStatus(this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0L, ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0L, SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testContainsKey(Method m) {
        SkipIndexingFlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipIndexingFlag = false;
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), ProtocolFlag.SkipIndexing.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), SKIP_INDEXING_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    private SkipIndexingFlagCheckCommandInterceptor init() {
        for (CommandInterceptor commandInterceptor : this.cacheManager.getCache("HotRodCache").getAdvancedCache().getInterceptorChain()) {
            if (!(commandInterceptor instanceof SkipIndexingFlagCheckCommandInterceptor)) continue;
            return (SkipIndexingFlagCheckCommandInterceptor)commandInterceptor;
        }
        SkipIndexingFlagCheckCommandInterceptor ci = new SkipIndexingFlagCheckCommandInterceptor();
        this.cacheManager.getCache("HotRodCache").getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)ci, 1);
        return ci;
    }

    private static int join(int flagId, int joinId) {
        return joinId | flagId;
    }
}

