/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.function.BiConsumer;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.Stoppable;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
public class HotRodConfigurationTest
extends AbstractInfinispanTest {
    public void testUserDefinedTimeouts() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyLockTimeout(26000L).topologyReplTimeout(31000L);
        this.withClusteredServer(builder, (cfg, distSyncTimeout) -> {
            AssertJUnit.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
            AssertJUnit.assertEquals((long)cfg.clustering().remoteTimeout(), (long)31000L);
            AssertJUnit.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
            AssertJUnit.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
            AssertJUnit.assertTrue((boolean)cfg.persistence().stores().isEmpty());
        });
    }

    public void testLazyLoadTopology() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyStateTransfer(false).topologyReplTimeout(43000L);
        this.withClusteredServer(builder, (cfg, distSyncTimeout) -> {
            AssertJUnit.assertEquals((long)cfg.clustering().remoteTimeout(), (long)43000L);
            AssertJUnit.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
            ClusterLoaderConfiguration clcfg = (ClusterLoaderConfiguration)cfg.persistence().stores().get(0);
            AssertJUnit.assertNotNull((Object)clcfg);
            AssertJUnit.assertEquals((long)clcfg.remoteCallTimeout(), (long)43000L);
        });
    }

    private void withClusteredServer(HotRodServerConfigurationBuilder builder, BiConsumer<Configuration, Long> consumer) {
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration()), cm -> Stoppable.useServer((AbstractProtocolServer)HotRodTestingUtil.startHotRodServer(cm, HotRodTestingUtil.serverPort(), builder), server -> {
            Configuration cfg = cm.getCacheConfiguration(((HotRodServerConfiguration)server.getConfiguration()).topologyCacheName());
            consumer.accept(cfg, cm.getCacheManagerConfiguration().transport().distributedSyncTimeout());
        }));
    }
}

