/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;

public class TestCallbackHandler
implements CallbackHandler {
    private final String username;
    private final char[] password;
    private final String realm;

    public TestCallbackHandler(String username, String realm, char[] password) {
        this.username = username;
        this.password = password;
        this.realm = realm;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password);
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)callback;
                authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback realmCallback = (RealmCallback)callback;
                realmCallback.setText(this.realm);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

