/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodProxyTest")
public class HotRodProxyTest
extends HotRodMultiNodeTest {
    private String proxyHost1 = "1.2.3.4";
    private String proxyHost2 = "2.3.4.5";
    private int proxyPort1 = 8123;
    private int proxyPort2 = 9123;

    @Override
    protected String cacheName() {
        return "hotRodProxy";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder config = HotRodTestingUtil.hotRodCacheConfiguration(HotRodProxyTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return config;
    }

    @Override
    protected HotRodServer startTestHotRodServer(EmbeddedCacheManager cacheManager, int port) {
        if (port == HotRodTestingUtil.serverPort()) {
            return HotRodTestingUtil.startHotRodServer(cacheManager, this.proxyHost1, this.proxyPort1);
        }
        return HotRodTestingUtil.startHotRodServer(cacheManager, port, this.proxyHost2, this.proxyPort2);
    }

    public void testTopologyWithProxiesReturned() {
        TestResponse resp = this.clients().get(0).ping((byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AbstractTestTopologyAwareResponse topoResp = resp.asTopologyAwareResponse();
        AssertJUnit.assertEquals((int)topoResp.topologyId, (int)this.currentServerTopologyId());
        AssertJUnit.assertEquals((int)topoResp.members.size(), (int)2);
        Set serverAddresses = this.servers().stream().map(HotRodServer::getAddress).collect(Collectors.toSet());
        topoResp.members.forEach(member -> AssertJUnit.assertTrue((boolean)serverAddresses.contains(member)));
    }
}

