/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.Handle;
import org.infinispan.server.hotrod.counter.BaseCounterTestStrategy;
import org.testng.AssertJUnit;

public abstract class BaseCounterImplTest<T>
implements BaseCounterTestStrategy {
    final Supplier<CounterManager> counterManagerSupplier;

    BaseCounterImplTest(Supplier<CounterManager> counterManagerSupplier) {
        this.counterManagerSupplier = counterManagerSupplier;
    }

    public static void assertNextValidEvent(Handle<EventLogger> eventLogger, long oldValue, long newValue) throws InterruptedException {
        CounterEvent event = ((EventLogger)eventLogger.getCounterListener()).waitingPoll();
        BaseCounterImplTest.assertValidEvent(event, oldValue, newValue);
    }

    public static void assertValidEvent(CounterEvent event, long oldValue, long newValue) {
        AssertJUnit.assertNotNull((Object)event);
        AssertJUnit.assertEquals((Object)CounterState.VALID, (Object)event.getOldState());
        AssertJUnit.assertEquals((Object)CounterState.VALID, (Object)event.getNewState());
        AssertJUnit.assertEquals((long)oldValue, (long)event.getOldValue());
        AssertJUnit.assertEquals((long)newValue, (long)event.getNewValue());
    }

    public static void assertNoEvents(Handle<EventLogger> eventLogger) {
        AssertJUnit.assertTrue((boolean)((EventLogger)eventLogger.getCounterListener()).eventLog.isEmpty());
    }

    @Override
    public void testAdd(Method method) {
        String counterName = method.getName();
        long initialValue = 10L;
        T counter = this.defineAndCreateCounter(counterName, 10L);
        this.assertCounterValue(counter, 10L);
        this.add(counter, 10L, 20L);
        this.assertCounterValue(counter, 20L);
        this.add(counter, -20L, 0L);
        this.assertCounterValue(counter, 0L);
    }

    @Override
    public void testReset(Method method) {
        String counterName = method.getName();
        long initialValue = 5L;
        T counter = this.defineAndCreateCounter(counterName, 5L);
        this.add(counter, 100L, 105L);
        this.assertCounterValue(counter, 105L);
        this.reset(counter);
        this.assertCounterValue(counter, 5L);
    }

    @Override
    public void testNameAndConfigurationTest(Method method) {
        String prefix = method.getName();
        List<CounterConfiguration> configs = this.configurationsToTest();
        for (int i = 0; i < configs.size(); ++i) {
            AssertJUnit.assertTrue((boolean)this.counterManagerSupplier.get().defineCounter(prefix + i, configs.get(i)));
            this.assertCounterNameAndConfiguration(prefix + i, configs.get(i));
        }
    }

    @Override
    public void testRemove(Method method) {
        String counterName = method.getName();
        long initialValue = 5L;
        T counter = this.defineAndCreateCounter(counterName, 5L);
        this.add(counter, 100L, 105L);
        this.assertCounterValue(counter, 105L);
        this.remove(counter);
        this.assertCounterValue(counter, 5L);
        this.add(counter, -100L, -95L);
        this.assertCounterValue(counter, -95L);
        this.counterManagerSupplier.get().remove(counterName);
        this.assertCounterValue(counter, 5L);
    }

    @Override
    public void testListenerAddAndRemove(Method method) throws InterruptedException {
        String prefix = method.getName();
        T counter1 = this.defineAndCreateCounter(prefix + "1", 0L);
        T counter2 = this.defineAndCreateCounter(prefix + "2", 10L);
        Handle<EventLogger> handle1 = this.addListenerTo(counter1, new EventLogger());
        Handle<EventLogger> handle1_1 = this.addListenerTo(counter1, new EventLogger());
        Handle<EventLogger> handle2 = this.addListenerTo(counter2, new EventLogger());
        this.add(counter1, 1L, 1L);
        this.add(counter1, -1L, 0L);
        this.add(counter1, 10L, 10L);
        this.add(counter2, 1L, 11L);
        this.add(counter2, 2L, 13L);
        BaseCounterImplTest.assertNextValidEvent(handle1, 0L, 1L);
        BaseCounterImplTest.assertNextValidEvent(handle1, 1L, 0L);
        BaseCounterImplTest.assertNextValidEvent(handle1, 0L, 10L);
        BaseCounterImplTest.assertNextValidEvent(handle1_1, 0L, 1L);
        BaseCounterImplTest.assertNextValidEvent(handle1_1, 1L, 0L);
        BaseCounterImplTest.assertNextValidEvent(handle1_1, 0L, 10L);
        BaseCounterImplTest.assertNextValidEvent(handle2, 10L, 11L);
        BaseCounterImplTest.assertNextValidEvent(handle2, 11L, 13L);
        BaseCounterImplTest.assertNoEvents(handle1);
        BaseCounterImplTest.assertNoEvents(handle1_1);
        BaseCounterImplTest.assertNoEvents(handle2);
        handle1.remove();
        this.add(counter1, 1L, 11L);
        BaseCounterImplTest.assertNextValidEvent(handle1_1, 10L, 11L);
        BaseCounterImplTest.assertNoEvents(handle1);
        handle1.remove();
        handle1_1.remove();
        handle2.remove();
        this.add(counter1, 1L, 12L);
        this.add(counter2, 1L, 14L);
        BaseCounterImplTest.assertNoEvents(handle1);
        BaseCounterImplTest.assertNoEvents(handle1_1);
        BaseCounterImplTest.assertNoEvents(handle2);
    }

    abstract <L extends CounterListener> Handle<L> addListenerTo(T var1, L var2);

    abstract void remove(T var1);

    abstract T defineAndCreateCounter(String var1, long var2);

    abstract void assertCounterValue(T var1, long var2);

    abstract void add(T var1, long var2, long var4);

    abstract void reset(T var1);

    abstract List<CounterConfiguration> configurationsToTest();

    abstract void assertCounterNameAndConfiguration(String var1, CounterConfiguration var2);

    public static class EventLogger
    implements CounterListener {
        final BlockingQueue<CounterEvent> eventLog = new LinkedBlockingQueue<CounterEvent>();

        public void onUpdate(CounterEvent entry) {
            this.eventLog.add(entry);
        }

        public CounterEvent poll() {
            return (CounterEvent)this.eventLog.poll();
        }

        public CounterEvent waitingPoll() throws InterruptedException {
            return this.eventLog.poll(30L, TimeUnit.SECONDS);
        }

        public int size() {
            return this.eventLog.size();
        }
    }
}

