/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.lang.invoke.MethodHandles;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerChildConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class HotRodServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<HotRodServerConfiguration, HotRodServerConfigurationBuilder>
implements Builder<HotRodServerConfiguration>,
HotRodServerChildConfigurationBuilder {
    private static Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);

    public HotRodServerConfigurationBuilder() {
        super(11222, HotRodServerConfiguration.attributeDefinitionSet());
    }

    public HotRodServerConfigurationBuilder self() {
        return this;
    }

    @Override
    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyHost(String proxyHost) {
        this.attributes.attribute(HotRodServerConfiguration.PROXY_HOST).set((Object)proxyHost);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyPort(int proxyPort) {
        this.attributes.attribute(HotRodServerConfiguration.PROXY_PORT).set((Object)proxyPort);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyLockTimeout(long topologyLockTimeout) {
        this.attributes.attribute(HotRodServerConfiguration.TOPOLOGY_LOCK_TIMEOUT).set((Object)topologyLockTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyReplTimeout(long topologyReplTimeout) {
        this.attributes.attribute(HotRodServerConfiguration.TOPOLOGY_REPL_TIMEOUT).set((Object)topologyReplTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyAwaitInitialTransfer(boolean topologyAwaitInitialTransfer) {
        this.attributes.attribute(HotRodServerConfiguration.TOPOLOGY_AWAIT_INITIAL_TRANSFER).set((Object)topologyAwaitInitialTransfer);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyStateTransfer(boolean topologyStateTransfer) {
        this.attributes.attribute(HotRodServerConfiguration.TOPOLOGY_STATE_TRANSFER).set((Object)topologyStateTransfer);
        return this;
    }

    public HotRodServerConfiguration create() {
        return new HotRodServerConfiguration(this.attributes.protect(), this.ssl.create(), this.authentication.create());
    }

    public HotRodServerConfigurationBuilder read(HotRodServerConfiguration template) {
        super.read((ProtocolServerConfiguration)template);
        this.authentication.read(template.authentication());
        return this;
    }

    public void validate() {
        super.validate();
        if (this.attributes.attribute(HotRodServerConfiguration.PROXY_HOST).isNull() && this.attributes.attribute(ProtocolServerConfiguration.HOST).isNull()) {
            throw log.missingHostAddress();
        }
        this.authentication.validate();
    }

    public HotRodServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public HotRodServerConfiguration build() {
        return this.build(true);
    }
}

