/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.buffer.ByteBuf;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.server.hotrod.tx.ControlByte;

public class TxWrite {
    private final long versionRead;
    private final byte control;
    private final byte[] value;
    private final int lifespan;
    private final int maxIdle;
    private final byte[] key;

    private TxWrite(long versionRead, byte control, byte[] value, int lifespan, int maxIdle, byte[] key) {
        this.versionRead = versionRead;
        this.control = control;
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.key = key;
    }

    public static TxWrite put(byte[] key, byte[] value, int lifespan, int maxIdle, byte control, long versionRead) {
        return new TxWrite(versionRead, control, value, lifespan, maxIdle, key);
    }

    public static TxWrite remove(byte[] key, byte control, long versionRead) {
        return new TxWrite(versionRead, ControlByte.REMOVE_OP.set(control), null, 0, 0, key);
    }

    void encodeTo(ByteBuf buffer) {
        ExtendedByteBuf.writeRangedBytes((byte[])this.key, (ByteBuf)buffer);
        buffer.writeByte((int)this.control);
        if (!ControlByte.NOT_READ.hasFlag(this.control) && !ControlByte.NON_EXISTING.hasFlag(this.control)) {
            buffer.writeLong(this.versionRead);
        }
        if (ControlByte.REMOVE_OP.hasFlag(this.control)) {
            return;
        }
        if (this.lifespan > 0 || this.maxIdle > 0) {
            buffer.writeByte(0);
            ExtendedByteBuf.writeUnsignedLong((long)this.lifespan, (ByteBuf)buffer);
            ExtendedByteBuf.writeUnsignedLong((long)this.maxIdle, (ByteBuf)buffer);
        } else {
            buffer.writeByte(136);
        }
        ExtendedByteBuf.writeRangedBytes((byte[])this.value, (ByteBuf)buffer);
    }
}

