/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.MultiHomedServerAddress;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="server.hotrod.HotRodMultiHomedAddressTest", groups={"functional"})
public class HotRodMultiHomedAddressTest
extends HotRodMultiNodeTest {
    public void testInAddrAny() throws IOException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface netif = en.nextElement();
            for (InterfaceAddress address : netif.getInterfaceAddresses()) {
                HotRodClient hotRodClient = this.createClient(this.servers().get(0), this.cacheName(), address.getAddress().getHostAddress());
                TestResponse ping = hotRodClient.ping((byte)2, 0);
                AssertJUnit.assertEquals((int)2, (int)ping.topologyResponse.members.size());
                for (ServerAddress serverAddress : ping.topologyResponse.members) {
                    InetAddress inetAddress = InetAddress.getByName(serverAddress.getHost(null));
                    AssertJUnit.assertTrue((boolean)MultiHomedServerAddress.inetAddressMatchesInterfaceAddress((byte[])inetAddress.getAddress(), (byte[])address.getAddress().getAddress(), (int)address.getNetworkPrefixLength()));
                }
                Exceptions.unchecked(() -> hotRodClient.stop().await());
            }
        }
    }

    @Override
    protected String cacheName() {
        return "multi";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration(HotRodMultiHomedAddressTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
    }

    @Override
    protected HotRodServer startTestHotRodServer(EmbeddedCacheManager cacheManager, int port) {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        return HotRodTestingUtil.startHotRodServer(cacheManager, "0.0.0.0", port, 0L, builder);
    }
}

