/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.impl.Util;
import org.infinispan.server.hotrod.counter.WeakCounterTestStrategy;
import org.infinispan.server.hotrod.counter.impl.BaseCounterImplTest;
import org.testng.AssertJUnit;

public class WeakCounterImplTestStrategy
extends BaseCounterImplTest<WeakCounter>
implements WeakCounterTestStrategy {
    private final Supplier<Collection<CounterManager>> allCounterManagerSupplier;

    public WeakCounterImplTestStrategy(Supplier<CounterManager> counterManagerSupplier, Supplier<Collection<CounterManager>> allCounterManagerSupplier) {
        super(counterManagerSupplier);
        this.allCounterManagerSupplier = allCounterManagerSupplier;
    }

    @Override
    public <L extends CounterListener> Handle<L> addListenerTo(WeakCounter counter, L logger) {
        return counter.addListener(logger);
    }

    @Override
    public WeakCounter defineAndCreateCounter(String counterName, long initialValue) {
        CounterManager counterManager = (CounterManager)this.counterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(initialValue).concurrencyLevel(8).build()));
        return counterManager.getWeakCounter(counterName);
    }

    @Override
    public void add(WeakCounter counter, long delta, long result) {
        Util.awaitCounterOperation((CompletableFuture)counter.add(delta));
    }

    @Override
    void remove(WeakCounter counter) {
        Util.awaitCounterOperation((CompletableFuture)counter.remove());
    }

    @Override
    void assertCounterValue(WeakCounter counter, long value) {
        AssertJUnit.assertEquals((long)value, (long)counter.getValue());
    }

    @Override
    void reset(WeakCounter counter) {
        Util.awaitCounterOperation((CompletableFuture)counter.reset());
    }

    @Override
    List<CounterConfiguration> configurationsToTest() {
        return Collections.singletonList(CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(1L).concurrencyLevel(2).build());
    }

    @Override
    void assertCounterNameAndConfiguration(String counterName, CounterConfiguration configuration) {
        this.allCounterManagerSupplier.get().forEach(counterManager -> {
            WeakCounter counter = counterManager.getWeakCounter(counterName);
            AssertJUnit.assertEquals((String)counterName, (String)counter.getName());
            AssertJUnit.assertEquals((Object)configuration, (Object)counter.getConfiguration());
        });
    }
}

