/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.hotrod.configuration.PolicyConfiguration;
import org.infinispan.server.hotrod.configuration.QOP;
import org.infinispan.server.hotrod.configuration.Strength;

public class SaslConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> SERVER_NAME = AttributeDefinition.builder((String)"serverName", (Object)"infinispan", String.class).immutable().build();
    public static final AttributeDefinition<Set<String>> MECHANISMS = AttributeDefinition.builder((String)"mechanisms", null, Set.class).initializer(LinkedHashSet::new).immutable().build();
    public static final AttributeDefinition<List<QOP>> QOP = AttributeDefinition.builder((String)"qop", new ArrayList(), List.class).initializer(ArrayList::new).immutable().build();
    public static final AttributeDefinition<List<Strength>> STRENGTH = AttributeDefinition.builder((String)"strength", new ArrayList(), Strength.class).initializer(ArrayList::new).immutable().build();
    static final AttributeDefinition<Map<String, String>> SASL_PROPERTIES = AttributeDefinition.builder((String)"property", null, Map.class).initializer(LinkedHashMap::new).autoPersist(false).immutable().build();
    private final AttributeSet attributes;
    private final Map<String, String> mechProperties;
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition("sasl");
    private final PolicyConfiguration policy;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SaslConfiguration.class, new AttributeDefinition[]{SERVER_NAME, MECHANISMS, QOP, STRENGTH, SASL_PROPERTIES});
    }

    SaslConfiguration(AttributeSet attributes, Map<String, String> mechProperties, PolicyConfiguration policy) {
        this.attributes = attributes.checkProtection();
        this.mechProperties = mechProperties;
        this.policy = policy;
    }

    public List<ConfigurationInfo> subElements() {
        return Collections.singletonList(this.policy);
    }

    Map<String, String> mechProperties() {
        return this.mechProperties;
    }

    public PolicyConfiguration policy() {
        return this.policy;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public String serverName() {
        return (String)this.attributes.attribute(SERVER_NAME).get();
    }

    public Set<String> mechanisms() {
        return (Set)this.attributes.attribute(MECHANISMS).get();
    }

    public List<QOP> qop() {
        return (List)this.attributes.attribute(QOP).get();
    }

    public List<Strength> strength() {
        return (List)this.attributes.attribute(STRENGTH).get();
    }

    public String toString() {
        return "SaslConfiguration{attributes=" + this.attributes + ", mechProperties=" + this.mechProperties + ", policy=" + this.policy + '}';
    }
}

